<?php

/**
 * Implementiert die CRUD Operationen für ISGW Causes
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class IsgwCauses {

	private		$m_attr,
			$q_attr,
			$start_attr,
			$order_attr,
			$sort_attr,
			$ent_attr,
			$dir_attr,
			$search_attr;

	private		$post_attr,
			$post_checked = 0;

	private 	$isRequestRejected = 0,
			$reasonRejected = array();

	private $record_count;

    function __construct($m, $get = array(), $post = array(), $session = array()) {
		// set index php page
		$this->m_attr = $m;

		// check GET variable
        $this->q_attr 	  = isset($get['q']) 	 ? Helper::sanitizeGet($get['q']	, 'q'	 ) : 0;
        $this->start_attr = isset($get['start']) ? Helper::sanitizeGet($get['start']	, 'start') : 0;
        $this->order_attr = isset($get['order']) ? Helper::sanitizeGet($get['order']	, 'order') : 0;
        $this->sort_attr  = isset($get['sort'])  ? Helper::sanitizeGet($get['sort']	, 'sort' ) : 0;
		$this->ent_attr   = Helper::sanitizeGet($get['ent']	, 'ent'	);
		$this->dir_attr   = Helper::sanitizeGet($get['dir']	, 'direction' );
		$this->search_attr= Helper::sanitizeGet($get['search']	, 'int>=0');

		// get error from modal or submit execution
		if (isset($get['error'])) {
        	$this->isRequestRejected = 1;
            $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}

		// check POST
		if (isset($post['save']) || isset($post['rest'])) {
			unset($post['m'], $post['dir'], $post['search'], $post['ent']);

			$list_post = array('rest' => 'select', 'save' => 'bool', 'causes' => 'bool'); 

			$list_options_select = array('rest' => array('Load default', 'Standardeinstellungen laden')); // TODO: rework the class to generalize with BUTTON_LOAD_DEF 
		
			$this->post_checked = 1;
			$this->post_attr = Helper::sanitizePost($post, $list_post, $this->post_checked, $this->reasonRejected, $list_options_select);

			$this->isRequestRejected = !$this->post_checked;
		}
	}

	/**
	 * Search for the causes map entries, that match the "search" criteria.
	 * @param beroAri $ba
	 * @param int $span
	 * @param int $start
	 * @return Object Query result 
	 */
	function filter($ba, $span, $start) {
		$where = "";
		if ((!isset($this->dir_attr) || $this->dir_attr == 'all' || $this->dir_attr == "") && $this->search_attr == "") {
			$where = "";
		} else if ((!isset($this->dir_attr) || $this->dir_attr == 'all' || $this->dir_attr == "") && $this->search_attr != "") {
			$where = ' 	WHERE direction like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or to_cause like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or from_cause like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or sip_response_message like ("%' . sqlite_escape_string($this->search_attr) . '%")';
		} else if (isset($this->dir_attr) && $this->dir_attr != 'all' && $this->dir_attr != "" && $this->search_attr != "") {
			$dir = $this->dir_attr;
			$where = ' 	WHERE (from_cause like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or to_cause like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or sip_response_message like ("%' . sqlite_escape_string($this->search_attr) . '%"))
								and (direction="' . sqlite_escape_string($dir) . '")';
		} else {
			$dir = $this->dir_attr;
			$where = ' WHERE direction="' . sqlite_escape_string($dir) . '"';
		}
		//Select all entries for navigation bar whithout limit
		$limit = 'limit ' . sqlite_escape_string($span) . ' offset ' . sqlite_escape_string($start);
		
		$query = $ba->select(' SELECT * from isgw_causes ' . $where . ' ORDER BY id asc ' . $limit);
		
		$recordcountquery = $ba->select(' SELECT * from isgw_causes ' . $where .' ORDER BY id asc' );
		$this->record_count = sqlite_num_rows( $recordcountquery ) > 1 ? sqlite_num_rows( $recordcountquery ) : "1";
		return $query;
	}

    /** 
     * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return HTML Page
	 */

	function display() {

		//pagination bar functions
		include "./includes/functions.php";
		$functions = new functions();

		$ba = new beroAri();
		$is_sbc_vm = $ba->get('is_sbc_vm') == 1;

		$m = $this->m_attr;
		$q = $this->q_attr;
		$start = $this->start_attr;
		$order = $this->order_attr;
		$sort = $this->sort_attr;

		$start = $start == '' ? 0 : $start;
		if (!is_null($this->ent_attr))
			$ba->set('span', $this->ent_attr);
		if (!$ba->get('span'))
			$ba->set('span', '15');
		$span = $ba->get('span');

		$name = "ISGW_CAUSES_TITLE_DIS";
		include('./includes/header.php');

		// Restore default causes
		if ($this->post_checked && isset($this->post_attr['rest'])) {
			if (!is_dir("/usr/conf/backup")) {
				Helper::mkdir($is_sbc_vm, "/usr/conf/backup");
			}
			if (file_exists("/usr/conf/isgw.causes")) {
				Helper::copy($is_sbc_vm, "/usr/conf/isgw.causes", "/usr/conf/backup/isgw.causes");
				Helper::unlink($is_sbc_vm, "/usr/conf/isgw.causes");
			}

			include_once('/usr/local/php/include/restore.Class.php');
			$restore = new restoreConfig(0, $ba);
			if (!$restore->isgwcauses()) {
				if (file_exists("/usr/conf/backup/isgw.causes")) {
					Helper::copy($is_sbc_vm, "/usr/conf/backup/isgw.causes", "/usr/conf/isgw.causes");
				} 
				$ret .= "<div class='text-center' style='margin-top:5px;color:red;'>". ISGW_CAUSES_ERROR_LOAD_DEFAULT ."</div>\n"; 
			}
			else {
				require_once "/usr/local/www/berogui/includes/isgwtelnet.php";
				$isgw = new isgwtelnet();
				$result = $isgw->isgw_login();
				$isgw->isgw_causesmapreload();
			}
		}
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

        $causes_table = $this->dynamic_table($ba, $span);
        
		$ret .= "<script>
					function del(table,id){
						conf = confirm('" . ISGW_CAUSES_DELETE_MESSAGE_DIS . "?');
						if (conf==false)
							return false;
						else
							window.location='./misc/delete.php?m=".$this->m_attr."&id='+id+'&table='+table;
					}
				 </script>
				 <div class='modal fade bs-example-modal-lg' id='causes-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
				  <div class='modal-dialog modal-lg'>
				    <div class='modal-content'>
				      <div class='modal-header'>
					<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
					<h4 class='modal-title' id='myModalLabel'>CAUSES MAP</h4>
				      </div>
				      <div class='modal-body'>
				      </div>
				    </div>
				  </div>
				</div>
					<form name='isgw_causes' action='' method='POST' >
					<input type=hidden name=m value='" . $m . "'>
					<br>
					<div class='content'>
					" . $causes_table .
                "</div>"
			. "<br>"
			. "<div class='text-center'>"
			. "<a href='modules/IsgwCauses/causes_popup.php' role='button' data-remote='false' data-toggle='modal' data-target='#causes-popup' class='btn btn-default'>"
			.  BUTTON_ADD . "</a>&nbsp;"
			. "<input name='rest' type='submit' class='btn btn-default' value='" . BUTTON_LOAD_DEF . "' onclick='javascript:return confirm(\"". ISGW_CAUSES_CONFIRM_LOAD_DEFAULT ."\");'>"
			. "</div>"
			. "</form>"
			. "<script>
			$('#causes-popup').on('show.bs.modal', function(e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
		</script>";

        //Create navbar
        $url_opts = array();
        $url_opts['sort'] = $sort;
        $url_opts['order'] = $order;
		$url_opts['search'] = $this->search_attr;
		$url_opts['dir'] = $this->dir_attr;
		$url_opts['ent'] = $this->ent_attr;

		if (empty($this->record_count)) {
			$query = $ba->select('SELECT * FROM isgw_causes');
			$this->record_count = sqlite_num_rows($query);
		}

        $ret .= "<div class='text-center'>"
			. $functions->displayNavigationBlock($m, $q, $url_opts, $start, $span, $this->record_count) 
			. "</div>";

        return $ret;
    }

	/* Generate direction filter */
	function getDirFilter() {
		$directions = array("SIP-ISGW", "SIP-ISDN", "ISDN-ISGW", "ISDN-SIP", "SIP-ANALOG");
		
		$url_attr = "index.php?m=" . $this->m_attr;
		$url_attr .= isset($this->search_attr) 	? "&search=" . $this->search_attr 	: "";
		$url_attr .= isset($this->ent_attr) 	? "&ent="	 . $this->ent_attr 		: "";
		$all_selected = $this->dir_attr == 'all' ? "selected" : "";

		$filter = "<select name='dir' class='form-control' id='dir' onchange=\"window.location='". $url_attr . "&dir='+getElementById('dir').options[getElementById('dir').selectedIndex].value;\">";
		$filter .= "<option value='all' $all_selected>" . ISGW_CAUSES_ALL_DIS . "</option>";
		
		foreach ($directions as $dir) {
			($this->dir_attr == $dir) ? $selected = "selected" : $selected = "";
			$filter .= "<option value='" . $dir . "' $selected>" . $dir . "</option>";
		}
	
		$filter .= "</select>";
		return $filter;
	}

	/* generate search filter */
	function getSearchFilter() {
		$url_attr = "index.php?m=" . $this->m_attr;
		$url_attr .= isset($this->dir_attr) ? "&dir=" . $this->dir_attr : "";
		$url_attr .= isset($this->ent_attr) ? "&ent=" . $this->ent_attr : "";
		
		$filter =  "<input name='search' class='form-control' placeholder='". ISGW_CAUSES_SEARCH_PLACEHOLDER_DIS ."' value='". $this->search_attr ."'"
			. "onkeydown=\"if (event.keyCode == 13){ window.location='". $url_attr ."&search='+search.value; return false;}\" >";

		return $filter;
	}

	/* generate Page entity filter */
	function getCountFilter($ba) {
		$spancount = array(10, 15, 20, 25, 30, 35, 40, 45, 50);
		
		$url_attr = "index.php?m=" . $this->m_attr;
		$url_attr .= isset($this->dir_attr) 	? "&dir="	 . $this->dir_attr 		: "";
		$url_attr .= isset($this->search_attr) 	? "&search=" . $this->search_attr 	: "";

		$filter = "<select name='ent' id='ent' class='form-control' onchange=\"window.location='" . $url_attr . "&ent='+getElementById('ent').options[getElementById('ent').selectedIndex].value;\">";
		
		foreach ($spancount as $span) {
			($ba->get('span') == $span) ? $selected = "selected" : $selected = "";
			$filter .= "<option value='$span' $selected>$span</option>";
		}
		return $filter;
	}

    /**
     * HTML Table for isgw_causes
	 * @return HTML Table
     */
    function dynamic_table($ba, $span) {

        if ($this->post_checked && isset($this->post_attr['save']) && isset($this->post_attr['causes'])) {
            $ba->set("causes_active", $this->post_attr['causes']);
            $table=Helper::activate(2, true, $this->m_attr, ACTIVATE);
        }
		$filter = "<th colspan='12'>"
			. "<form>"
			. "<div class='row'>";
		$filter .= "<div class='col-sm-1'>" . DIALPLAN_DIRECTION_DIS . ": </div>"
			. "<div class='col-sm-2'>" . $this->getDirFilter() . "</div>";
		$filter .= "<div class='col-sm-1'>" . DIALPLAN_SEARCH_DIS . ":</div>"
			. "<div class='col-sm-4'> " . $this->getSearchFilter() . "</div>";
		$filter .= "<div class='col-sm-2'>" . DIALPLAN_ENTRIES_DIS . ":</div>"
			. "<div class='col-sm-2'> " . $this->getCountFilter($ba) . "</div>";
		
		$filter .= "</div>"
			. "</form>"
			. "</th>";

        require_once("./includes/lang.php");

		//table header
		$start = $this->start_attr;
        $columns = $ba->column_type('isgw_causes');
        $i = 0;
        foreach ($columns as $column => $type) {
            if ($column != 'id') {
                $cols_name[$i] = $column;
                if ($column == "direction")
                    $column = ISGW_CAUSES_CALL_DIRECTION_DIS;
                if ($column == "to_cause")
                    $column = ISGW_CAUSES_TO_CAUSE_DIS;
                if ($column == "from_cause")
                    $column = ISGW_CAUSES_FROM_CAUSE_DIS;
				if ($column == "sip_response_message")
					$column = ISGW_CAUSES_RESPONSE_MESSAGE_DIS;
                $cols .= "<th>" . $column . "</th>";
                $i++;
            }
        }
		$cols .= "<th>" . DIALPLAN_TOOLS_DIS . "</th>";

		//table content, crud btns
        $page = (($start / $span) + 1);
        if (!$start) $start = 0;
        $id = 0;

        for ($j = 1; $j <= $page; $j++) {
			$query = $this->filter($ba, $span, $start);
            //$query = $ba->select('SELECT * FROM isgw_causes ORDER BY id asc limit 15 offset ' . sqlite_escape_string($start));
            $rows = '';

            while ($entry = $ba->fetch_array($query)) {
                $rows .= "<tr>";
                $entry['sip_response_message'] = str_replace("\r\n", "<br>", $entry['sip_response_message']);
                $dir = preg_split("/-/", $entry['direction']);
                
				$rows .= "<td>" . $entry['direction'] . "</td>";
                $rows .= "<td>" . $entry['from_cause'] . " (" . $dir[0] . ")</td>";
                $rows .= "<td>" . $entry['to_cause'] . " (" . $dir[1] . ")</td>";
				$rows .= $entry['sip_response_message'] != "" ? "<td>" . $entry['sip_response_message'] . "</td>" : "<td>" . ISGW_CAUSES_NONE_DIS . "</td>";
                
				$id = $entry['id'];
                $rows .= "<td class='buttons'>
					<a href='modules/IsgwCauses/causes_popup.php?id=" . $entry['id'] . "' data-remote='false' data-toggle='modal' data-target='#causes-popup' class='popup_download'>
					<img src='./includes/images/modify.png' onmouseover=\"Tip('" . MOD_ISGW_CAUSES_MODIFY . "')\" onmouseout='UnTip()'>
				</a>
				&nbsp;
				<a class='popup_download' onclick=\"del('isgw_causes','" . $id . "');\">
            	    <img src='./includes/images/delete.png' onmouseover=\"Tip('" .
                        MOD_ISGW_CAUSES_DELETE . "')\" onmouseout='UnTip()'>
				</a>

				</td></tr>";
            }
        }
        $table = "<table class='table table-striped table-bordered' id='table'><tr>" . $filter . "</tr><tr>" . $cols . "</tr>" . $rows . "</table>";
		
        return $table;
    }
}

?>
