<?php

/**
 * Implementiert das Neustarten und Zurücksetzten des Gateways
 * @author Miguel Palmer <mp@beronet.com>
 */
require_once("/usr/local/www/berogui/includes/Helper/Helper.php");
include_once('/usr/www/include/SQLite2ToSQLite3.php');

function trimurl($urlPBX){
	// --- url trimmer ---
	// remove /stuff
	$urlPBX = trim($urlPBX, '/');
	// remove any http or https stuff
	if (!preg_match('#^http(s)?://#', $urlPBX)) {
		$urlPBX = 'http://' . $urlPBX;
	}
	$urlParts = parse_url($urlPBX);
	// remove www
	$pbxIP = preg_replace('/^www\./', '', $urlParts['host']);
	return $pbxIP;
}

class RebootReset{

	private $post_attr;
	private $isRequestRejected = 0,
			$reasonRejected = array();

	function __construct($m, $get = array(), $post = array(), $session = array()){
		$this->post_attr = $post;

		// get error from wizard var check
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			switch ($get['error']) {
				case '1':
					$this->reasonRejected = Helper::displayErrorMessage($get['request'], $get['checkor'], $get['key']);
					break;
				case '2':
					$this->reasonRejected = "\t<div id='error-script' class='text-center' style='margin-top: 5px; color: red;'>\n{$get['reason']}\n\t</div>\n";
					break;
			}
		}
	}

	/**
	 * Generiert die HTML Seite
	 * @return string HTML code
	 */
	function display(){

		$name = "REBOOT_RESET_TITLE_DIS";
		include('./includes/header.php');

		if ($this->isRequestRejected) {
			$ret .= $this->reasonRejected;
		}

		require_once('/usr/fallback/beroConf.php');
		$bc = new beroConf('root');
		$is_sbc_vm = $bc->get('root', 'is-sbc-vm') == 1;

		// get modules installed
		$list_lifs = Helper::getLif();

		// check the modules
		$recreate = 'recreate_sbcvm.php';
		$is_t1e1_installed  = false;
		$display_wizard_btn = false;
		if (!$is_sbc_vm) {
			$recreate = 'recreate_sbc.php';
			foreach ($list_lifs as $lif) {
				// is T1/E1 installed ?
				if (preg_match('#t1e1#', $lif)) {
					$is_t1e1_installed  = true;
					$display_wizard_btn = true;
					break;
				}
				// at least one module plugged to display the wizard button
				else if (!(preg_match('#none#', $lif))) {
					$display_wizard_btn = true;
				}
			}
		}
		/* when the pbx parameter in the url is given -> wizard modal opens automatically
		 * - when you come from a 3CX, the pbxIP parameter is given with the IP of the 3CX
		 * - when no pbxIP parameter is given, it checks the IP of the page we got redirected from
		 * -> Passes both the pbx parameter as name and the IP into the wizard and the corresponding fields are autofilled */

		unset($_SESSION['pbx'], $_SESSION['pbxip']);

		/* CHECKING GET REQUEST */
		$list_get = array(
			'pbx'   => 'group-name',
			'pbxip' => 'hostname'
		);

		$load_popup = 1;
		$invalid = array();

		$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid);

		if (isset($_GET['pbx']) && $display_wizard_btn == true && $load_popup == 1) {
			$pbxwiz = htmlspecialchars($_GET['pbx']);

			/* set $pbxip  */
			if (isset($_GET['pbxip'])) {
				$_SESSION['pbxip'] = $_GET['pbxip'];
			} elseif (isset($_SERVER['HTTP_REFERER'])) {
				$_SESSION['pbxip'] = trimurl($_SERVER['HTTP_REFERER']);
			} else {
				$_SESSION['pbxip'] = '';
			}

			$_SESSION['pbx'] = $pbxwiz;

			echo "<script>$(document).ready(function(){ $('#reset-popup').modal('show'); });</script>";
		} elseif ($load_popup == 0) {
			echo "<script>window.location='index.php?m=RebootReset&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
			exit(1);
		}

		if ($_POST['rebootRecoveryMode'] && !$is_sbc_vm) {
			$bc->set('root', 'boot_recoverymode', '1');
			echo ("<script>window.location.replace('reboot.php');</script>");
		}

		if ($this->post_attr['v'] != "Yes"):
			ob_start();
			?>
			<br>
			<div class="panel panel-default" style="max-width:600px; margin:auto;">
				<div class="panel-heading text-center lead">
					<?php echo REBOOT_RESET_BUTTON_REBOOT_DIS ?>
				</div>
				<div class="panel-body">
					<p class="text-center lead">
						<?php echo REBOOT_RESET_MESSAGE_REB_DIS ?>
					</p>
					<div class="text-center">
						<input type='button' id='rebootbtn' class='btn btn-default' style='margin-top:5px;'
							value='<?php echo REBOOT_RESET_BUTTON_REBOOT_DIS ?>'>
						<?php if (!$is_sbc_vm) { ?>
							<form action='' id='form-recoverymode' method='POST' style='display:unset;'>
								<input type='submit' id='recoverybtn' class='btn btn-default' style='margin-top:5px;'
									name='rebootRecoveryMode' data-toggle='tooltip' title='<?php echo RECOVERY_MODE_BUTTON_TT; ?>'
									value='<?php echo RECOVERY_MODE_BUTTON_REBOOT_DIS ?>'>
							</form>
						<?php } ?>
					</div>
				</div>
			</div>

			<br>
			<br>

			<div class="panel panel-default" style="max-width:600px; margin:auto;">
				<div class="panel-heading text-center lead">
					<?php echo REBOOT_RESET_BUTTON_FACT_RES_DIS ?>
				</div>
				<div class="panel-body">
					<form class='form-horizontal' id='form-rebootreset'
						action='modules/RebootReset/<?php echo $recreate; ?>?val=yes' method='POST' name='reset'>
						<input type='hidden' name='popup' id='hiddenPopup' value='1'>

						<p class="text-center lead">
							<?php echo REBOOT_RESET_MESSAGE_RESET_DIS ?>
						</p>
						<p class="text-center lead">
							<?php echo REBOOT_RESET_KEEP_SETTINGS_DIS ?>
						</p>

						<div class="form-group" style="margin-bottom: unset;">
							<label for='id_keep_set' class='col-sm-6 control-label'>
								<?php echo REBOOT_RESET_KEEP_SETTINGS_RES_DIS ?>
							</label>
							<div class='col-sm-4 form-checkbox'>
								<input type='checkbox' name='keep_set' id='id_keep_set' style='margin-top:5px;' checked>
							</div>
						</div>
						<div class="form-group" style="margin-bottom: unset;">
							<label for='id_keep_acl_set' class='col-sm-6 control-label'>
								<?php echo REBOOT_RESET_KEEP_ACL_SETTINGS_RES_DIS ?>
							</label>
							<div class='col-sm-4 form-checkbox'>
								<input type='checkbox' name='keep_acl_set' id='id_keep_acl_set' style='margin-top:5px;' checked>
							</div>
						</div>
						<div class="form-group" style="margin-bottom: unset;">
							<label for='id_keep_provisioning_set' class='col-sm-6 control-label'>
								<?php echo REBOOT_RESET_KEEP_PROVISIONING_SETTINGS_RES_DIS ?>
							</label>
							<div class='col-sm-4 form-checkbox'>
								<input type='checkbox' name='keep_provisioning_set' id='id_keep_provisioning_set'
									style='margin-top:5px;' checked>
							</div>
						</div>
						<div class="form-group" style="margin-bottom: unset;">
							<label for='keep_time_set' class='col-sm-6 control-label'>
								<?php echo REBOOT_RESET_KEEP_TIME_SETTINGS_RES_DIS ?>
							</label>
							<div class='col-sm-4 form-checkbox'>
								<input type='checkbox' name='keep_time_set' id='keep_time_set' style='margin-top:5px;' checked>
							</div>
						</div>
						<?php if (!$is_sbc_vm) { ?>
							<div class="form-group" style="margin-bottom: unset;">
								<label for='id_keep_cloud_set' class='col-sm-6 control-label'>
									<?php echo REBOOT_RESET_KEEP_CLOUD_SETTINGS_RES_DIS ?>
								</label>
								<div class='col-sm-4 form-checkbox'>
									<input type='checkbox' name='keep_cloud_set' id='id_keep_cloud_set' style='margin-top:5px;' checked>
								</div>
							</div>
						<?php } ?>
						<div class="form-group" style="margin-bottom: unset;">
							<label for='keep_sip_set' class='col-sm-6 control-label'>
								<?php echo REBOOT_RESET_KEEP_SIP_SETTINGS_RES_DIS ?>
							</label>
							<div class='col-sm-4 form-checkbox'>
								<input type='checkbox' name='keep_sip_set' id='keep_sip_set' style='margin-top:5px;'>
							</div>
						</div>
						<?php if ($is_sbc_vm) { ?>
							<div class="form-group" style="margin-bottom: unset;">
								<label for='id_keep_guipassword_set' class='col-sm-6 control-label'>
									<?php echo REBOOT_RESET_KEEP_GUIPASSWORD_DIS ?>
								</label>
								<div class='col-sm-4 form-checkbox'>
									<input type='checkbox' id='id_keep_guipassword_set' name='keep_guipassword_set'
										style='margin-top:5px;' checked>
								</div>
							</div>
						<?php } ?>
						<?php if (!$is_sbc_vm) { ?>
							<div class="form-group" style="margin-bottom: unset;">
								<label for='keep_app_set' class='col-sm-6 control-label'>
									<?php echo REBOOT_RESET_KEEP_APP_CONFIG_RES_DIS ?>
								</label>
								<div class='col-sm-4 form-checkbox'>
									<input type='checkbox' name='keep_app_set' id='keep_app_set' style='margin-top:5px;'>
								</div>
							</div>
							<div class="form-group">
								<label for='keep_prefix_set' class='col-sm-6 control-label'>
									<?php echo REBOOT_RESET_KEEP_PREFIX_SETTING_RES_DIS ?>
								</label>
								<div class='col-sm-4 form-checkbox'>
									<input type='checkbox' name='keep_prefix_set' id='keep_prefix_set' style='margin-top:5px;' checked>
								</div>
							</div>
						<?php } ?>
						<?php if ($is_t1e1_installed) { ?>
							<p class="text-center lead" style="margin-top: 15px;">
								<?php echo REBOOT_RESET_TITLE_MODE_DIS ?>
							</p>
							<div class="form-group" style="margin-top: -10px;">
								<label for='keep_hw_set' class='col-sm-6 control-label'>
									<?php echo REBOOT_RESET_DEFAULT_DIS ?>
								</label>
								<div class='col-sm-4 form-checkbox'>
									<input type='checkbox' name='keep_hw_set' id='id_keep_hw_set' style='margin-top:5px;'
										onchange="updateHTMLcode();" checked>
								</div>
							</div>
						<?php } ?>
						<div class='text-center'>
							<div id='button_html' style='margin-top: 15px;;display:inline-block;'>
								<input type='submit' class='btn btn-default' name='v' style='margin-right: 1px;'
									value='<?php echo REBOOT_RESET_BUTTON_FACT_RES_DIS ?>'>

								<?php if ($display_wizard_btn) { ?>
									<a role='button' data-remote='false' data-toggle='modal' data-target='#reset-popup'
										class='btn btn-default' style='margin-right: 4px;'
										onclick="$('hiddenPopup').prop('value', 1);">Wizard</a>

								<?php } ?>

							</div>

							<button form="" class="btn btn-default" data-toggle="tooltip" id="buttonSelect"
								title="<?php echo BACK_RES_SELECT ?>" onclick="select('export')">
								<?php echo BACKUP_RESTORE_CHECKBOX_SELECT ?>
							</button>
							<button form="" class="btn btn-default" data-toggle="tooltip" id="buttonDeselect"
								title="<?php echo BACK_RES_DESELECT ?>" onclick="deselect('export')">
								<?php echo BACKUP_RESTORE_CHECKBOX_DESELECT ?>
							</button>
						</div>
					</form>
				</div>
			</div>

			<br>

			<script type='text/javascript'>
				//select deselect button functions
				addEventListener("click", (event) => {
					if ($(':checkbox:input:checked').length > 0 && $(':checkbox:input:checked').length < $(':checkbox').length) {
						$('#buttonDeselect').show();
						$('#buttonSelect').show();
					}
					else if ($(':checkbox:input:checked').length == 0) {
						$('#buttonDeselect').hide();
						$('#buttonSelect').show();
					}
					else {
						$('#buttonSelect').hide();
						$('#buttonDeselect').show();
					}
				});

				function deselect(group) {
					$(':checkbox').prop('checked', false);
				}
				function select(group) {
					$(':checkbox').prop('checked', true);
				}

				$(document).ready(function () {
					$('[data-toggle="tooltip"]').tooltip({ placement: 'auto bottom', html: true, trigger: 'hover' });
				});

				$('#form-recoverymode').submit(function (e) {
					if (confirm("<?php echo REBOOT_RECOVERYMODE_DIS; ?>") == false) {
						e.preventDefault();
					}
				});

				$('#form-rebootreset').submit(function (e) {
					var confirmed = true;
					if (<?php echo ($is_sbc_vm ? '1' : '0'); ?>) {
						if (!$('#id_keep_guipassword_set').is(':checked')) {
							confirmed = confirm('<?php echo FACTORY_RESET_SBCVM_NEW_BEROGUI_PASSWORD_ALERT; ?>');
						}
					}
					else {
						confirmed = confirm("<?php echo REBOOT_RESET_CONFIRM_RESET_DIS; ?>");
					}
					if (confirmed) {
						return true;
					}
					e.preventDefault();
				});
			</script>
			<div class='modal fade bs-example-modal-lg' id='reset-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel'
				aria-hidden='true'>
				<div class='modal-dialog modal-lg'>
					<div class='modal-content'>
						<div class='modal-header'>
							<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span
									aria-hidden='true'>&times;</span></button>
							<h4 class='modal-title' id='myModalLabel'>
								<?php if (isset($pbxwiz)) {
									echo $pbxwiz . " - " . WIZARD_TITLE_DIS;
								} else {
									echo WIZARD_TITLE_DIS;
								} ?>
							</h4>
						</div>
						<div class='modal-body'></div>
					</div>
				</div>
			</div>

			<script type="text/javascript">
				$(document).ready(function () {
					$("#dialog-confirm").dialog({
						autoOpen: false,
						modal: true
					});

					$("#rebootbtn").click(function (e) {
						e.preventDefault();
						var rebootThis = this;
						var targetUrl = 'reboot.php';
						$.ajax({
							url: "misc/getTotalCalls.php",
							cache: false,
							success: function (data) {
								if (data == 0) {
									var message = '<?php echo REBOOT_RESET_CONFIRM_REBOOT_DIS; ?>';
									showDialog(targetUrl, message, 'Reboot');
								}
								else {
									var message = '<?php echo REBOOT_RESET_TOTAL_CALLS_DIS; ?>:' + data + '<br/><?php echo REBOOT_RESET_CONFIRM_GRACEFUL_DIS; ?>';
									showDialog(targetUrl, message, 'Reboot', 'reboot');
								}
							},
						});
					});
				});
				$('#reset-popup').on('show.bs.modal', function (e) {

					var link = $(e.relatedTarget);
					var wizard = document.getElementById('hiddenPopup').value;

					var keepSet = document.getElementById('id_keep_set').checked;
					var keepAcl = document.getElementById('id_keep_acl_set').checked;
					var keepProvisioning = document.getElementById('id_keep_provisioning_set').checked;
					var keepCloudSet = document.getElementById('id_keep_cloud_set').checked;
					var keepPrefixSet = document.getElementById('keep_prefix_set').checked;
					var keepPrefixSet = document.getElementById('keep_time_set').checked;

					if (wizard == 1) {
						session();

						$.ajax({
							type: 'POST',
							url: 'modules/Wizard/wizard_popup.php',
							data: { init: true, settings: 'Network', save_net: keepSet, save_acl: keepAcl, save_provsioning: keepProvisioning, save_cloud: keepCloudSet, save_prefix: keepPrefixSet },
							success: function (data) {
								$('.modal-body').html(data);
							},
							failure: function (errMsg) {
								alert(errMsg);
							}
						});
					}
					<?php if ($is_t1e1_installed) { ?>
						else /* wizard !=1 */  {
							var keepSipSet = document.getElementById('keep_sip_set').checked;
							var keepAppSet = document.getElementById('keep_app_set').checked;

							$.ajax({
								type: 'GET',
								url: 'modules/RebootReset/factoryreset_popup.php',
								data: { Set: keepSet, AclSet: keepAcl, ProvisioningSet: keepProvisioning, CloudSet: keepCloudSet, SipSet: keepSipSet, AppSet: keepAppSet, PrefixSet: keepPrefixSet },
								success: function (data) {
									$('#myModalLabel').html('<?php echo REBOOT_RESET_TITLE_MODE_DIS; ?>');
									$('.modal-body').html(data);
								},
								failure: function (errMsg) {
									alert(errMsg);
								}
							});
						}
					<?php } ?>
				});

				$('#reset-popup').on('hidden.bs.modal', function (e) {
					$('.modal-body').empty();
				});

				<?php if ($is_t1e1_installed) { ?>
					function updateHTMLcode() {
						var keepHwSet = document.getElementById('id_keep_hw_set').checked;

						if (keepHwSet) {
							document.getElementById("button_html").innerHTML = "<input type='submit' class='btn btn-default' name='v' style='margin-right: 4px;' value='<?php echo REBOOT_RESET_BUTTON_FACT_RES_DIS ?>'>" +
								"<a role='button' data-remote='false' data-toggle='modal' data-target='#reset-popup' class='btn btn-default' " +
								"style='margin-right: 4px;' onclick=\"$('hiddenPopup').prop('value', 1);\">Wizard</a>";
						}
						else {
							document.getElementById("button_html").innerHTML = "<a role='button' data-remote='false' data-toggle='modal' data-target='#reset-popup' " +
								"class='btn btn-default' style='margin-right: 4px;' onclick=\"$('#hiddenPopup').prop('value', 0);\">" +
								"<?php echo REBOOT_RESET_BUTTON_FACT_RES_DIS; ?>" +
								"</a>" +
								"<a role='button' data-remote='false' data-toggle='modal' data-target='#reset-popup' class='btn btn-default' " +
								"style='margin-right: 4px;' onclick=\"$('#hiddenPopup').prop('value', 1);\">Wizard</a>";
						}
					}
				<?php } ?>
			</script>
			<?php
		endif;
		$ret .= ob_get_clean();

		// Rückgabe: Der Inhalt von der HTML-Seite
		return $ret;
	}

}
?>