<?php
define('BEROGUI', '/usr/local/www/berogui');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once(BEROGUI .'/includes/Helper/Helper.php');

$m = 'RebootReset';

$exec = 1;
$invalid = [];

/* [AS INTERN SCRIPT] */
$fromBerocloud = 0;
if ($argc > 1) {
	$fromBerocloud = 1;
	$_POST = [ 'keep_set' => 0, 'keep_acl_set' => 0, 'keep_sip_set' => 0, 'keep_guipassword_set' => 0];
	foreach ($argv as $input) {
		$dummy = explode('=', $input);
		if (isset($_POST[$dummy[0]])) {
			$_POST[$dummy[0]] = $dummy[1];
		}
	}
}

/* [INTERN FUNCTIONS] */
function fetchData($ba, $table) {
	$data = [];
	$query = $ba->select("SELECT * FROM $table");
	while ($entry = sqlite_fetch_array($query)) {
		$dummy = [];
		foreach ($entry as $key => $value) {
			if (!is_numeric($key)) {	
				$dummy[$key] = $value;
			}
		}
		if (!empty($dummy)) {
			$data[] = $dummy;
		}
	}
	return $data;
}

function generatePassword($length) {
	return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)))),1,$length);
}

function encryptPassword($password) {
	include(BEROGUI .'/includes/password_func.php');
	return tep_encrypt_password($password);
}

/* [CHECKING SESSION] */
if (!$fromBerocloud) {
	$newTarget = '/app/berogui/index.php?m=RebootReset';
	include(BEROGUI .'/includes/session.php');
	unset($newTarget);
}

/* [CHECKING BERONODE] */
$error = [];
if (!Helper::isBeronodeRunning($error)) {
	Helper::redirectOnBeronodeError($m, $error);
}

/* [CHECKING GET] */
unset($_GET);

/* [CHECKING POST] */
unset($_POST['popup'], $_POST['v']);

$post = [ 'keep_set' => 'bool', 'keep_acl_set' => 'bool', 'keep_sip_set' => 'bool', 'keep_guipassword_set' => 'bool'];
$post = Helper::sanitizePost($_POST, $post, $exec, $invalid);
unset($_POST);

/* [EXECUTING] */
if (!$exec) {
	if ($fromBerocloud) {
		die('Invalid data');
	}
	Helper::redirectOnInvalidData($m, $invalid);
}

require_once('/usr/fallback/beroConf.php');
$bc = new beroConf('root');

require_once(BEROGUI .'/misc/database.php');
$ba = new beroAri();

// saving data
$toKeep = [];
$toKeepKeyVal = [];
foreach (['keep_set' => 'sbc_vpns', 'keep_acl_set' => 'acl', 'keep_sip_set' => 'sip'] as $key => $table) {
	if (isset($post[$key]) && $post[$key]) {
		$toKeep[$table] = fetchData($ba, $table);
	}
}
if (isset($post['keep_sip_set']) && $post['keep_sip_set']) {
	// fetch SIP Stacks
	$keys = [ 'sip_transport', 'ssl_version', 'tos_rtp', 'tos_sip', 'rtp_port_selection', 'rtpports', 'stack_active', 'sip_bindport', 'registration_offset'];
	foreach (['wan', 'lan'] as $iface) {
		foreach ($keys as $key) {
			$toKeepKeyVal["{$key}_{$iface}"] = $ba->get("{$key}_{$iface}");
		}
	}
	// fetch Dialplan
	$toKeep['dialplan'] = fetchData($ba, 'dialplan');
}

$cloud_addr = $bc->get('root', 'cloudAddress');

// executing setup scripts
$setup = [
	'setup_berogui.sh',
	//'setup_sbcapi.sh',
	'setup_openvpn.sh clean',
	'clean_logs.sh',
];

$output = null;
try {
	foreach (array_map(['Helper', 'concatenateString'], $setup, array_fill(0, count($setup), '/usr/local/beroNet/sbin/')) as $cmd) {
		Helper::system(1, $cmd, $output, ['timeout' => 10]);
	}
}
catch (Exception $e) {
	$msg = "Executing setup scripts failed: {$e->getMessage()}";
	if ($fromBerocloud) {
		die($msg);
	}
	Helper::redirectOnError($m, 2, $msg);
}

// restoring data
unset($ba, $bc);
$ba = new beroAri();
$bc = new beroConf('root');

if (!empty($toKeep)) {
	foreach ($toKeep as $table => $data) {
		foreach ($data as $entry) {
			$ba->insertTable($table, $entry['id'], array_diff_key($entry, array('id' => '')));
		}
	}
}
if (!empty($toKeepKeyVal)) {
	foreach ($toKeepKeyVal as $key => $val) {
		$ba->set($key, sqlite_escape_string($val));
	}
}
if (isset($post['keep_set']) && $post['keep_set'] && !empty($toKeep['sbc_vpns'])) {
	try {
		Helper::system(1, "/usr/local/beroNet/sbin/setup_openvpn.sh", $output, ['timeout' => 3]);
	}
	catch (Exception $e) {
		$msg = "Setting up the OpenVPN Server failed: {$e->getMessage()}";
		if ($fromBerocloud) {
			die($msg);
		}
		Helper::redirectOnError($m, 2, $msg);
	}
	$data = [
		'is-vpn-running'=> 1,
		'lan-ipaddr'		=> Helper::getNetworkIpAddr('tun0', 1),
		'lan-mode' 			=> 'lan-wan',
		'lan-netmask'		=> Helper::getNetworkMask('tun0', 1),
	];
	foreach ($data as $key => $value) {
		$bc->set('root', $key, $value);
	}
}

// generating, crypting, saving and sending new password
if (!isset($post['keep_guipassword_set']) || !$post['keep_guipassword_set']) {
	$newPass = generatePassword(10);

	require_once('/usr/php/include/CloudSbcApi.php');
	$cloud = new CloudSbcApi($bc, $ba, ['addr' => $cloud_addr]);
	$res = $cloud->send('sendPassword', ['password' => $newPass]);

	$email = '-1';
	if (preg_match('/^email sent to \{(.*)\}$/', $res, $matched)) {
		if (strlen($matched[1]) > 0) {
			$email = $matched[1];
			// save new password
			$enc_newPass = encryptPassword($newPass);
			$sbcConf = parse_ini_file('/etc/beroNet/sbc.conf');
			$sbcConf['BEROGUI_PASSWORD'] = $enc_newPass;
			file_put_contents('/etc/beroNet/sbc.conf', "#### SBC Config File #####\n\n". Helper::buildIniString($sbcConf));
			$ba->update("UPDATE users SET password='$enc_newPass' WHERE user ='admin'");
		}
	}
	$bc->set('root', 'factory-reset-email', $email);
}

// redirect
$bc->set('root', 'is-factory-reset', 1);
if ($fromBerocloud) {
	$skip_session = true;
	include(BEROGUI .'/includes/create_files.php');
	die('succeeded');
}
echo '<script>window.location.href="../../includes/create_files.php"</script>'; 
exit(0);
?>
