<?php

/**
 * Implementiert die Statusseite über aktive Anrufe
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class StateCalls {

	private $_m = null;

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->_m = $m;
	}

	/**
	* Generates the HTML Table for active calls
	* @return string
	*/
	function showTable($isgw) {

		$channelresult = $isgw->isgw_channelstate();
		$pstn_sip = "";
		$sip_pstn = "";
		$pstn_pstn = "";
		$sip_sip = "";
		//LISTING CALL OPERATIONS
		$rows = "";
		$rows = explode("\n", $channelresult);

		$i = 0;

		$zeilen = array();
		foreach ($rows as $row) {
			if (trim($row) != "" && strpos($row, "LISTING CALL OPERATIONS COMPACT") === false) {
				$values = explode("\t", $row);
				$zeilen[intval($values[0])] = $row;
			}
		}
		/*
		 * Dieses Array enthält die Zeilen IDs von dem zweiten Eintrags eines PSTN zu PSTN
		 * Eintrags, damit dieser nicht im weiteren Durchlauf als Call ausgewertet wird.
		 */
		$dontUse = array();
		foreach ($rows as $row) {
			$row = htmlspecialchars($row);
			$values = explode("\t", $row);
			if (trim($row) != "" && strpos($row, "LISTING CALL OPERATIONS COMPACT") === false && (!in_array(intval($values[0]), $dontUse))) {
				$CALL_DIRECTION = $values[2];
				//CALL TYPE
				$tmp = explode("=", $values[13]);
				$CALL_TYPE = $tmp[1];
				switch ($CALL_TYPE) {
					case "MSP_VOICE_ACTIVE":
						$CALL_TYPE = "Voice";
						break;
					case "MSP_T38_ACTIVE":
						$CALL_TYPE = "T38";
						break;
					case "MSP_TONEGEN_ACTIVE":
						$CALL_TYPE = "Tonegen";
						break;
					case "MSP_BRIDGED";
						$CALL_TYPE = "Bridged";
						break;
					case "MSP_REMOTE_BRIDGED":
						$CALL_TYPE = "Remote Bridged";
						break;
				}
				unset($tmp);
				if (strpos($values[13], "MSP_BRIDGED") !== false) {
					/**
					 * PSTN zu PSTN Einträgen
					 */
					$tmp = explode("=", $values[10]);
					array_push($dontUse, intval($tmp[1]));
					//Werte des zweiten Eintrags
					$values1 = explode("\t", $zeilen[intval($tmp[1])]);

					unset($tmp);

					//Call direction
					$CALL_DIRECTION = $values[2];
					$CALL_DIRECTION1 = $values1[2];
					$tmp = explode("2", $CALL_DIRECTION);
					$tmp1 = explode("2", $CALL_DIRECTION1);
					/**
					 * @todo Replace if else if by switch case
					 */
					if (trim($tmp[0]) == "A") {
						$CALL_DIRECTION = "ANALOG";
					} else if (trim($tmp[0]) == "I") {
						$CALL_DIRECTION = "ISDN";
					} else if (trim($tmp[0]) == "G") {
						$CALL_DIRECTION = "GSM";
					} else if (trim($tmp[0]) == "C") {
						$CALL_DIRECTION = "CAS";
					}

					/**
					 * @todo Replace if else if by switch case
					 */
					if (trim($tmp1[1]) == "A") {
						$CALL_DIRECTION1 = "ANALOG";
					} else if (trim($tmp1[1]) == "I") {
						$CALL_DIRECTION1 = "ISDN";
					} else if (trim($tmp1[1]) == "G") {
						$CALL_DIRECTION1 = "GSM";
					} else if (trim($tmp1[1]) == "C") {
						$CALL_DIRECTION1 = "CAS";
					}
					$CALL_DIRECTION = $CALL_DIRECTION . " --> " . $CALL_DIRECTION1;
					unset($tmp);
					unset($tmp1);

					//DAD
					$tmp = explode("=", $values[4]);
					$tmp1 = explode("=", $values1[4]);
					$DAD = $tmp[1];
					$DAD1 = $tmp1[1];
					//$DAD=$DAD . " --> " . $DAD1;
					unset($tmp);
					unset($tmp1);


					//OAD
					$tmp = explode("=", $values[3]);
					$tmp1 = explode("=", $values1[3]);
					$OAD = $tmp[1];
					$OAD1 = $tmp1[1];
					//$OAD=$OAD . " --> " . $OAD1;
					unset($tmp);
					unset($tmp1);

					//Port/Channel
					if (strpos($values[5], "P/C") !== false) {
						$tmp = explode("=", $values[5]);
						$PORT_CHANNEL = $tmp[1];
						unset($tmp);
					} else {
						$tmp = explode("=", $values[5]);
						$PORT_CHANNEL = $tmp[1] . ":1";
						unset($tmp);
					}

					if (strpos($values1[5], "P/C") !== false) {
						$tmp1 = explode("=", $values1[5]);
						$PORT_CHANNEL1 = $tmp1[1];
						unset($tmp1);
					} else {
						$tmp1 = explode("=", $values1[5]);
						$PORT_CHANNEL1 = $tmp1[1] . ":1";
						unset($tmp1);
					}

					//Connection time
					$tmp = explode("=", $values[9]);
					$CONN_TIME = $tmp[1];


					$pstn_pstn .= "<tr>";
					$pstn_pstn .= "<td>" . $CALL_DIRECTION . "</td>";
					$pstn_pstn .= "<td>" . $PORT_CHANNEL . "</td>";
					$pstn_pstn .= "<td>" . $DAD . "</td>";
					$pstn_pstn .= "<td>" . $OAD . "</td>";
					$pstn_pstn .= "<td>" . $PORT_CHANNEL1 . "</td>";
					$pstn_pstn .= "<td>" . $DAD1 . "</td>";
					$pstn_pstn .= "<td>" . $OAD1 . "</td>";
					$pstn_pstn .= "<td>" . $CONN_TIME . " (" . $CALL_TYPE . ")</td>";
					$pstn_pstn .= "</tr>";
					$i++;

					//SIP zu PSTN
				} elseif (trim($CALL_DIRECTION) == "S2I" || trim($CALL_DIRECTION) == "S2A" || trim($CALL_DIRECTION) == "S2G" || trim($CALL_DIRECTION) == "S2C") {

					//Index
					$INDEX = $values[0];
					//Call direction
					switch ($CALL_DIRECTION) {
						case "S2I":
							$CALL_DIRECTION = "SIP --> ISDN";
							break;
						case "S2A":
							$CALL_DIRECTION = "SIP --> ANALOG";
							break;
						case "S2G":
							$CALL_DIRECTION = "SIP --> GSM";
							break;
						case "S2C":
							$CALL_DIRECTION = "SIP --> CAS";
							break;
					}


					//DAD
					$tmp = explode("=", $values[4]);
					$DAD = $tmp[1];
					unset($tmp);

					//OAD
					$tmp = explode("=", $values[3]);
					$OAD = $tmp[1];
					unset($tmp);

					//Port/Channel
					if (strpos($values[5], "P/C") !== false) {
						$tmp = explode("=", $values[5]);
						$CHANNEL_PORT = $tmp[1];
						unset($tmp);
					} else {
						$tmp = explode("=", $values[5]);
						$CHANNEL_PORT = $tmp[1] . ":1";
						unset($tmp);
					}

					//FROM
					$tmp = explode("=", $values[6]);
					$FROM = $tmp[1];
					unset($tmp);

					//TO
					$tmp = explode("=", $values[7]);
					$TO = $tmp[1];
					unset($tmp);

					//RTP INFO
					$tmp = explode("=", $values[8]);
					$RTP_INFO = $tmp[1];
					unset($tmp);

					//Connection time
					$tmp = explode("=", $values[9]);
					$CONN_TIME = $tmp[1];
					unset($tmp);

					$sip_pstn .= "<tr>";
					$sip_pstn .= "<td>" . $CALL_DIRECTION . "</td>";
					$sip_pstn .= "<td>" . $TO . "</td>";
					$sip_pstn .= "<td>" . $FROM . "</td>";
					$sip_pstn .= "<td>" . $RTP_INFO . "</td>";
					$sip_pstn .= "<td>" . $CHANNEL_PORT . "</td>";
					$sip_pstn .= "<td>" . $DAD . "</td>";
					$sip_pstn .= "<td>" . $OAD . "</td>";
					$sip_pstn .= "<td>" . $CONN_TIME . " (" . $CALL_TYPE . ")</td>";
					$sip_pstn .= "</tr>";
					$i++;
					//PSTN zu SIP
				} elseif (trim($CALL_DIRECTION) == "I2S" || trim($CALL_DIRECTION) == "A2S" || trim($CALL_DIRECTION) == "G2S" || trim($CALL_DIRECTION) == "C2S") {
					//Call direction
					switch ($CALL_DIRECTION) {
						case "I2S":
							$CALL_DIRECTION = "ISDN --> SIP";
							break;
						case "A2S":
							$CALL_DIRECTION = "ANALOG --> SIP";
							break;
						case "G2S":
							$CALL_DIRECTION = "GSM --> SIP";
							break;
						case "C2S":
							$CALL_DIRECTION = "CAS --> SIP";
							break;
					}
					unset($tmp);

					//DAD
					$tmp = explode("=", $values[4]);
					$DAD = $tmp[1];
					unset($tmp);

					//OAD
					$tmp = explode("=", $values[3]);
					$OAD = $tmp[1];
					unset($tmp);

					//Port/Channel
					if (strpos($values[5], "P/C") !== false) {
						$tmp = explode("=", $values[5]);
						$CHANNEL_PORT = $tmp[1];
						unset($tmp);
					} else {
						$tmp = explode("=", $values[5]);
						$CHANNEL_PORT = $tmp[1] . ":1";
						unset($tmp);
					}

					//FROM
					$tmp = explode("=", $values[6]);
					$FROM = $tmp[1];
					unset($tmp);

					//TO
					$tmp = explode("=", $values[7]);
					$TO = $tmp[1];
					unset($tmp);

					//RTP INFO
					$tmp = explode("=", $values[8]);
					$RTP_INFO = $tmp[1];
					unset($tmp);

					//Connection time
					$tmp = explode("=", $values[9]);
					$CONN_TIME = $tmp[1];
					unset($tmp);

					$pstn_sip .= "<tr>";
					$pstn_sip .= "<td>" . $CALL_DIRECTION . "</td>";
					$pstn_sip .= "<td>" . $CHANNEL_PORT . "</td>";
					$pstn_sip .= "<td>" . $DAD . "</td>";
					$pstn_sip .= "<td>" . $OAD . "</td>";
					$pstn_sip .= "<td>" . $TO . "</td>";
					$pstn_sip .= "<td>" . $FROM . "</td>";
					$pstn_sip .= "<td>" . $RTP_INFO . "</td>";
					$pstn_sip .= "<td>" . $CONN_TIME . " (" . $CALL_TYPE . ")</td>";
					$pstn_sip .= "</tr>";
					$i++;
					//SIP zu SIP
				} elseif (trim($CALL_DIRECTION) == "S2S") {
					//Index
					$INDEX = $values[0];
					//Call direction
					$CALL_DIRECTION = "SIP --> SIP";

					//FROM ORIG
					$tmp = explode("=", $values[3]);
					$FROMO = $tmp[1];
					unset($tmp);

					//TO ORIG
					$tmp = explode("=", $values[4]);
					$TOO = $tmp[1];
					unset($tmp);

					//RTP INFO ORIG
					$tmp = explode("=", $values[5]);
					$RTP_INFOO = $tmp[1];
					unset($tmp);

					//FROM DEST
					$tmp = explode("=", $values[6]);
					$FROMD = $tmp[1];
					unset($tmp);

					//TO DEST
					$tmp = explode("=", $values[7]);
					$TOD = $tmp[1];
					unset($tmp);

					//RTP INFO DEST
					$tmp = explode("=", $values[8]);
					$RTP_INFOD = $tmp[1];
					unset($tmp);

					//Connection time
					$tmp = explode("=", $values[9]);
					$CONN_TIME = $tmp[1];
					unset($tmp);

					$sip_sip .= "<tr>";
					$sip_sip .= "<td>" . $CALL_DIRECTION . "</td>";
					$sip_sip .= "<td>" . $TOO . "</td>";
					$sip_sip .= "<td>" . $FROMO . "</td>";
					$sip_sip .= "<td>" . $RTP_INFOO . "</td>";
					$sip_sip .= "<td>" . $TOD . "</td>";
					$sip_sip .= "<td>" . $FROMD . "</td>";
					$sip_sip .= "<td>" . $RTP_INFOD . "</td>";
					$sip_sip .= "<td>" . $CONN_TIME . " (" . $CALL_TYPE . ")</td>";
					$sip_sip .= "</tr>";
					$i++;
				}
			}
		}//end foreach


		if ($pstn_pstn != "") {
			$ret .= "<br>";
			$ret .= "<table class='table table-striped table-bordered active' style='width:95% !important; margin:auto;'>";
			$ret .= "<tr><th colspan=8>" . ACTIVE_CHANNELS_PSTN_PSTN_DIS . "</th></tr>";
			$ret .= "<tr><th></th><th colspan=3>" . ACTIVE_CHANNELS_ORIGINATOR_DIS . "</th><th colspan=3>" . ACTIVE_CHANNELS_DESTINATION_DIS . "</th><th></th></tr>";
			$ret .= "<tr><td><b>" . ACTIVE_CHANNELS_DIRECTION_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_PORT_DIS . " : " . ACTIVE_CHANNELS_CHANNEL_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_DAD_DIS . "</b></td>";
			$ret .= "<td><b>" . ACTIVE_CHANNELS_OAD_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_PORT_DIS . " : " . ACTIVE_CHANNELS_CHANNEL_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_DAD_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_DAD_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_CONNECTION_TIME_DIS . "</b></td></tr>";
			$ret .= $pstn_pstn;
			$ret .= "</table>";
		}
		if ($sip_pstn != "") {
			$ret .= "<br>";
			$ret .= "<table  class='table table-striped table-bordered active' style='width:95% !important; margin:auto;'>";
			$ret .= "<tr><th colspan=8>" . ACTIVE_CHANNELS_SIP_PSTN_DIS . "</th></tr>";
			$ret .= "<tr><th></th><th colspan=3>" . ACTIVE_CHANNELS_ORIGINATOR_DIS . "</th><th colspan=3>" . ACTIVE_CHANNELS_DESTINATION_DIS . "</th><th></th></tr>";
			$ret .= "<tr><td><b>" . ACTIVE_CHANNELS_DIRECTION_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_TO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_FROM_DIS . "</b></td>";
			$ret .= "<td onmouseover=\"Tip('" . RTP_INFO . "')\" onmouseout='UnTip()'><b>" . ACTIVE_CHANNELS_RTP_INFO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_PORT_DIS . " : " . ACTIVE_CHANNELS_CHANNEL_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_DAD_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_OAD_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_CONNECTION_TIME_DIS . "</b></td></tr>";
			$ret .= $sip_pstn;
			$ret .= "</table>";
		}
		if ($pstn_sip != "") {
			$ret .= "<br>";
			$ret .= "<table  class='table table-striped table-bordered active' style='width:95% !important; margin:auto;'>";
			$ret .= "<tr><th colspan=8>" . ACTIVE_CHANNELS_PSTN_SIP_DIS . "</th></tr>";
			$ret .= "<tr><th></th><th colspan=3>" . ACTIVE_CHANNELS_ORIGINATOR_DIS . "</th><th colspan=3>" . ACTIVE_CHANNELS_DESTINATION_DIS . "</th><th></th></tr>";
			$ret .= "<tr><td><b>" . ACTIVE_CHANNELS_DIRECTION_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_PORT_DIS . " : " . ACTIVE_CHANNELS_CHANNEL_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_DAD_DIS . "</b></td>";
			$ret .= "<td><b>" . ACTIVE_CHANNELS_OAD_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_TO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_FROM_DIS . "</b></td>";
			$ret .= "<td onmouseover=\"Tip('" . RTP_INFO . "')\" onmouseout='UnTip()'><b>" . ACTIVE_CHANNELS_RTP_INFO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_CONNECTION_TIME_DIS . "</b></td></tr>";
			$ret .= $pstn_sip;
			$ret .= "</table>";
		}
		if ($sip_sip != "") {
			$ret .= "<br>";
			$ret .= "<table  class='table table-striped table-bordered active' style='width:95% !important; margin:auto;'>";
			$ret .= "<tr><th colspan=8>" . ACTIVE_CHANNELS_SIP_SIP_DIS . "</th></tr>";
			$ret .= "<tr><th></th><th colspan=3>" . ACTIVE_CHANNELS_ORIGINATOR_DIS . "</th><th colspan=3>" . ACTIVE_CHANNELS_DESTINATION_DIS . "</th><th></th></tr>";
			$ret .= "<tr><td><b>" . ACTIVE_CHANNELS_DIRECTION_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_TO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_FROM_DIS . "</b></td>";
			$ret .= "<td onmouseover=\"Tip('" . RTP_INFO . "')\" onmouseout='UnTip()'><b>" . ACTIVE_CHANNELS_RTP_INFO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_TO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_FROM_DIS . "</b></td>";
			$ret .= "<td onmouseover=\"Tip('" . RTP_INFO . "')\" onmouseout='UnTip()'><b>" . ACTIVE_CHANNELS_RTP_INFO_DIS . "</b></td><td><b>" . ACTIVE_CHANNELS_CONNECTION_TIME_DIS . "</b></td></tr>";
			$ret .= $sip_sip;
			$ret .= "</table>";
		}
		$ret .= "<br><b>" . ACTIVE_CHANNELS_TOTAL_CALLS_DIS . ":" . $i . "</b>";
		return $ret;
	}

	/**
	 * Generates HTML gui & ajax for refreshing
	 * @return string
	 */
	function refresh() {
		$destination = base64_encode("/app/berogui/index.php?m={$this->_m}");
		$ret .= "<script type='text/javascript' language='javascript'>
	
		function autoRefresh() {
			if (window.ajax_noAuto == true) { return false; }
			refresh();
		}
			
		function refresh() {
			$.ajax({
				type: 'POST',
				url: './modules/StateCalls/statecalls_ajax.php', 
				data: {
					'refresh': true,
				},
				success: function (data) {
					$('#content').html(data);
				},
				error: function (res, errorThrown) {
					if (res.status == 408) {
						window.location.href = './includes/login.php?reason=sess_expd&destination=$destination';
					}
				},
				timeout:4500 
			});  
		}
	
	$(document).ready(function(){

		$('#checkajax').click(function(){
	       	        if (this.checked) {
	        		window.ajax_noAuto = false;
	       			$('#reload').hide();
	       		} else {
	       			window.ajax_noAuto = true; 
	       			$('#reload').show();	
	        	}
	        });
        });
	$(function() {
		window.setInterval('autoRefresh()', 5000);
	});
		
	</script>
	
	<div>
		<div class='form-checkbox'>
		<p>". AUTO_REFRESH_DIS."&nbsp;<input id='checkajax' name='checkajax' id='reload' type='checkbox' checked></p>
		</div>
		<button id='reload' class='btn btn-default' value='reload' onclick='refresh()' style='display:none; margin-left:28px'>" .BUTTON_RELOAD. "</button> 
	</div>";

	return $ret;

	}
	
	/**
	 * Generates the HTML page
	 * @return string
	 */
	function display(){	
		require_once "./includes/isgwtelnet.php";
		$name = "ACTIVE_CHANNELS_TITLE_DIS";
		include('./includes/header.php');
		$isgw = new isgwtelnet();
	
		if ($isgw->isgw_login() == false) {
			return $ret;
		}

		$ret.= $this->refresh();
		$ret.= "<div id='content'>";	
		$ret.= $this->showTable($isgw);
		$ret.= "</div>";
		return $ret;
	}

}

?>
