<?php

class SipWizard 
{
	// scenario variables
	var $pbx 	    = 'Pbx';
	var $which_scenario = 1;

	// sip variables
	var $sip_name 	   = array('id' => 'sip-name' 	  , 'name' => 'sip_name'     , 'title' => SIP_NAME_DIS		 	, 'tooltip' => TRUNKS_SIP_NAME	   , 'type' => 'text'	 , 'postCheck' => 'group-name'	 , 'options' => '');
	var $sip_server    = array('id' => 'sip-server'   , 'name' => 'sip_server'   , 'title' => WIZARD_SIP_SERVER_ADDRESS_DIS	, 'tooltip' => TRUNKS_SIP_REGISTRAR, 'type' => 'text'	 , 'postCheck' => 'hostname'	 , 'options' => '');
	var $sip_user 	   = array('id' => 'sip-user'	  , 'name' => 'sip_user'     , 'title' => SIP_USER_DIS		       	, 'tooltip' => TRUNKS_SIP_USER	   , 'type' => 'text'	 , 'postCheck' => 'config-option', 'options' => '');
	var $sip_secret	   = array('id' => 'sip-secret'   , 'name' => 'sip_secret'   , 'title' => SIP_SECRET_DIS	       	, 'tooltip' => TRUNKS_SIP_SECRET   , 'type' => 'password', 'postCheck' => 'config-option', 'options' => '');
	var $sip_transport = array('id' => 'sip-transport', 'name' => 'sip_transport', 'title' => SIP_STACKS_SIP_TRANSPORT_DIS 	, 'tooltip' => TRUNKS_SIP_TRANSPORT, 'type' => 'select'	 , 'postCheck' => 'select'	 , 'options' => array('udp', 'tcp', 'tls'));
	var $sip_register  = array('id' => 'sip-register' , 'name' => 'sip_register' , 'title' => SIP_REGISTER_DIS		, 'tooltip' => WIZARD_SIP_REGISTER , 'type' => 'checkbox', 'postCheck' => 'bool'	 , 'options' => '');

	// pbx variables 
	var $pbx_server = array('id' => 'pbx-server', 'name' => 'pbx_server', 'title' => WIZARD_PBX_SERVER_ADDR_DIS, 'tooltip' => '', 'type' => 'text', 'postCheck' => 'hostname'	, 'options' => array()				   );
	var $pbx_port	= array('id' => 'pbx-port'  , 'name' => 'pbx_port'  , 'title' => WIZARD_PBX_SERVER_PORT_DIS, 'tooltip' => '', 'type' => 'text', 'postCheck' => 'int-range'	, 'options' => array('min' => 1025, 'max' => 65355));

	function __construct ($scenario = 1) // gateway = 1    -   pbx = 2   -   provider = 3    -    manual = 4
	{
		if (isset($_SESSION['pbx'])) {
			$this -> which_scenario = 2;			
        } else {
        	$this -> which_scenario = $scenario;                          
        }   
	}

	// private
	function _get_post_list() 
	{
		return array($this->sip_name, $this->sip_server, $this->sip_user, $this->sip_secret, $this->sip_transport, $this->sip_register, $this->pbx_server, $this->pbx_port);
	}

	function _display_select_field ($parameter, $options, $tab = "\t\t\t")
	{
		$options_str = '';
		foreach ($options as $key => $option)
		{
			$options_str .= $tab. "\t\t\t<option size='40' value='{$option['value']}'{$option['selected']}>{$option['value']}</option>\n";
		}

		return	  $tab. "<div class='form-group' data-toggle='tooltip' title='{$parameter['tooltip']}'>\n"
			. $tab. "\t<label class='col-sm-3 control-label' for='{$parameter['id']}-for'>{$parameter['title']}</label>\n"
			. $tab. "\t<div class='col-sm-8'>\n"
			. $tab. "\t\t<select class='form-control input-sm' name='{$parameter['name']}' id='{$parameter['id']}'>\n" 
			. $options_str 
			. $tab. "\t\t</select>\n"
			. $tab. "\t</div>\n"
			. $tab. "</div>\n";
	}

	function _display_simple_field ($parameter, $value = '', $javascript = '', $tab = "\t\t\t")
	{
		$checked = '';
		$class 	 = "class='form-control input-sm'";
		if (strcmp($parameter['type'], 'checkbox') == 0)
		{
			$class   = "class=''";
			$checked = ((strlen($value) != 0 || $value) ? ' checked' : '');
		}

		$html_str = 	  $tab. "<div class='form-group' id='{$parameter['id']}-tr'>\n"
				. $tab. "\t<label for='{$parameter['name']}' class='col-sm-3 control-label'>{$parameter['title']}</label>\n"
				. $tab. "\t<div class='col-sm-8'>\n"
				. $tab. "\t\t<input type='{$parameter['type']}' $class data-toggle='tooltip' name='{$parameter['name']}' id='{$parameter['id']}' title='{$parameter['tooltip']}' value='$value' $javascript $checked/>\n"
				. $tab. "\t</div>\n"
				. $tab. "</div>\n";
	
		return $html_str;
	}

	function _manual_content($sip_cfg)
	{
		$html_str = '';
		
		foreach (array($this -> sip_name, $this -> sip_server, $this -> sip_user, $this -> sip_secret) as $sip_parameter)
		{
			$value = (isset($sip_cfg[$sip_parameter['name']]) ? $sip_cfg[$sip_parameter['name']] : '');
			$html_str .= $this -> _display_simple_field($sip_parameter, $value);
		}

		// transport
		$options = array('udp' => array('value' => 'UDP', 'selected' => ' selected'),
				 'tcp' => array('value' => 'TCP', 'selected' => ''	   ),
				 'tls' => array('value' => 'TLS', 'selected' => ''	   ));

		if (isset($sip_cfg[$this -> sip_transport['name']]))
		{
			$dummy_options = $options;
			foreach ($options as $key => $option)
			{
				$dummy_options[$key]['selected'] = '';
				if (strcmp($sip_cfg[$this -> sip_transport['name']], $dummy_options[$key]['value']) == 0)
				{
					$dummy_options[$key]['selected'] = ' selected';	
					break;
				}	
			}
			$options = $dummy_options;
		}

		$transport = $this -> _display_select_field($this -> sip_transport, $options);

		// register
		$register = $this -> _display_simple_field($this -> sip_register, isset($sip_cfg[$this -> sip_register['name']]) ? $sip_cfg[$this -> sip_register['name']] : '');

		return 	  $html_str
			. $transport
			. $register;
	}

	function _gateway_content ($sip_cfg)
	{
		return $this -> _manual_content($sip_cfg);
	}

	function _pbx_content ($pbx_cfg)
	{
		$html_str = '';

		foreach (array($this -> pbx_server, $this -> pbx_port) as $pbx_parameter)
		{ 
			if (isset($pbx_cfg[$pbx_parameter['name']])) {
				$value = $pbx_cfg[$pbx_parameter['name']];
			} else if (isset($_SESSION['pbxip'])) {
				$value = $_SESSION['pbxip'];
				unset($_SESSION['pbxip']);
			} else {
				$value = '';
			}
			$html_str .= $this -> _display_simple_field($pbx_parameter, $value);
		}
		
		return $html_str;
	}

	function _provider_content ($provider_cfg)
	{
		return $this -> _gateway_content($provider_cfg);
	}

	// public
	function get_content_modal ($wizard_cfg, &$title_modal) 
	{
		switch ($this -> which_scenario)
		{
			default:
			case 1:
				return $this -> _gateway_content($wizard_cfg);
			case 2:
				if (isset($_SESSION['pbx'])) {
					$title_modal = $_SESSION['pbx']." ".SIP_POPUP_SETTINGS_TAB;
				} else {
					$title_modal = WIZARD_PBX_SETTINGS_DIS;
				}
				return $this -> _pbx_content($wizard_cfg);
			case 3:
				$title_modal = WIZARD_PROVIDER_SETTINGS_DIS;
				return $this -> _provider_content($wizard_cfg);
		}
	}

	function get_general_javascript_code ($form)
	{
		if ($this -> which_scenario == 2)
		{
			ob_start();
?>
<script type="text/javascript">
        $(document).ready(function () {
                $("#<?php echo $form; ?>").validate({
                        rules: {
                                <?php echo $this -> pbx_server['name']; ?>: {
					required: true,
                                        checkHostname: true,
                                },
                                <?php echo $this -> pbx_port['name']; ?>: {
                                        range: [<?php echo $this -> pbx_port['options']['min']; ?>, <?php echo $this -> pbx_port['options']['max']; ?>],
                                },
                        }
                });
        });
</script>
<?php
			return ob_get_clean();
		}
		else
		{
			ob_start();
?>
<script type="text/javascript">
        $(document).ready(function () {
		$("#<?php echo $form; ?>").validate({
        		rules: {
        			<?php echo $this -> sip_name['name']; ?>: {
					required: true,
                	 		checkDigChar: true,
               			},
              			<?php echo $this -> sip_server['name']; ?>: {
                	        	required: true,
					checkHostname: true,
               			},
				<?php echo $this -> sip_user['name']; ?>: {
					specChar: true,
				},
          		}
		});
	});
</script>
<?php
			return ob_get_clean();
		}

		return '';
	}

	function get_unique_form_javascript_code ()
	{
		ob_start();
?>
			$('#sip-register').prop('value', '0');
			if ($('#sip-register').prop('checked') == true)
			{
				$('#sip-register').prop('value', '1');
			}

<?php
		return ob_get_clean();
	}

	function organize_settings ($sip_cfg)
	{
		$string_erased = "sip_";
		if ($this -> which_scenario == 2)
		{
			$string_erased = "pbx_";
		}

		$organized_settings = array();
		foreach ($sip_cfg as $parameter => $value)
		{
			if (preg_match("#$string_erased#", $parameter))
			{
				$organized_settings[str_replace($string_erased, '', $parameter)] = $value;
			}
		}

		return $organized_settings;
	}

	function get_summary_settings ($scenario, $settings, $tab = "\t\t\t")
	{
		// title
		$title = $tab. "<p class='text-center h4'>". ($scenario == 2 ? WIZARD_PBX_SETTINGS_DIS : WIZARD_SIP_SETTINGS_DIS) ."</p>\n";

		// table
		$th_titles = '';
		$td_values = '';
		foreach ($settings as $parameter => $value)
		{
			if (strcmp($parameter, 'secret') != 0)
			{
				$th_titles .= "<th>". ucfirst($parameter) ."</th>";
				$td_values .= "<td>$value</td>"	   		  ;
			}
		}

		$table =  $tab. "<table class='table table-striped table-bordered'>\n"
			. $tab. "\t<tr>". $th_titles ."</tr>\n"
			. $tab. "\t<tr>". $td_values ."</tr>\n"
			. $tab. "</table>\n";

		return $title . $table; 
	}

        function get_post_conditions_list()
        {
		$condition = array('post' => array(), 'options' => array());
                foreach ($this -> _get_post_list() as $post_input) 
		{
                        $conditions['post'][$post_input['name']] = $post_input['postCheck'];
                        $conditions['options'][$post_input['name']] = $post_input['options'];
                }

                return $conditions;
        }
}
?>
