#!/bin/bash
#
#	Pre-Install script during AppFs installation
#
# VERSION=1
# CHANGES=init

FW=${1}
IMAGE_DIR=/tmp/images
BEROCONF=/usr/fallback/beroconf

[ -f /usr/fallback/helper ] && source /usr/fallback/helper

source /tmp/VERSION
PREFIX=${TYPE:common}
LOGFILE=/usr/conf/permlog/install-preinstall-${PREFIX}.log

### FUNCTIONS ###
function log() {
	pipe=/tmp/install_pipe
	output="[install_${PREFIX}] $(date): ${1}"

	## show on GUI / cmd line 
	[ -p ${pipe} ] && echo "${output}" &>${pipe}

 	## write on logs
	if type -t permlog 2>&1 >/dev/null; then
		permlog "install-preinstall-${PREFIX}" "[install_${PREFIX}]" "${1}"
	else
		echo "${output}" >> ${LOGFILE}
	fi
}

### MAIN ###
[ -f ${LOGFILE} ] && rm ${LOGFILE}

## check php-cgi belongs to /home/admin. if not, block the installation
if [ ! -f /home/admin/bin/php-cgi ]; then
	log "Device not ready to install 21.03 FW or higher"
	touch /tmp/has.issue
	exit 0
fi

## check firmware integrity
log "Checking firmware integrity"
if ! tar xzf ${IMAGE_DIR}/${FW} tmp/content.txt -C / 2>/dev/null; then
	log "FAIL: File content.txt missing in archive. Leaving !"
	touch /tmp/has.issue
	exit 2
fi
tar tzf ${IMAGE_DIR}/${FW} > /tmp/compare-content.txt
for i in $(cat /tmp/content.txt | sed "s/\/$//"); do
	if ! grep "${i}" /tmp/compare-content.txt >/dev/null; then
		log "FAIL: File ${i} missing in archive. Leaving !"
		touch /tmp/has.issue
		exit 3
	fi
done
rm /tmp/{content,compare-content}.txt

## Checking Versions of installed Kernel and Firmware
CHECK_FAILED=0

KERNEL=1
[ -f /usr/conf/VERSION.kernel ] && KERNEL=$(expr match "$(cat /usr/conf/VERSION.kernel)" ".*VERSION=\([0-9]*\)")

FPGA=1
[ -f /sys/class/beronet/fpga/version ] && FPGA=$(cat /sys/class/beronet/fpga/version)

FIRMWARE=1
[ -f /usr/conf/VERSION.firmware ] && FIRMWARE=$(expr match "$(cat /usr/conf/VERSION.firmware)" ".*VERSION=\([0-9]*\)")

ROOTFS=1
[ -f /pkginfo/VERSION.rootfs ] && ROOTFS=$(expr match "$(cat /pkginfo/VERSION.rootfs)" ".*PKG_VERSION=\([0-9]*\)")

if [ "${NEED_KERNEL}" -gt "${KERNEL}" ]; then
	log "FAIL: Please update Kernel to version ${NEED_KERNEL} and try again!"
	CHECK_FAILED=1
fi
if [ "${NEED_FPGA}" -gt "${FPGA}" ]; then
	log "FAIL: Please update FPGA to version ${NEED_FPGA} and try again!"
	CHECK_FAILED=1
fi
if [ "${NEED_FIRMWARE}" -gt "${FIRMWARE}" ]; then
	log "FAIL: Please update Firmware to version ${NEED_FIRMWARE} and try again!"
	CHECK_FAILED=1
fi
if [ "${NEED_ROOTFS}" -gt "${ROOTFS}" ]; then
	log "FAIL: Please update RootFS to version ${NEED_ROOTFS} and try again!"
	CHECK_FAILED=1
fi

if [ "${CHECK_FAILED}" = "1" ]; then
	log "ERROR: checking the VERSION failed"
	touch /tmp/has.issue
	exit 4
fi

## check succeeded. remove flags from older failed installation
## can be removed in the future
${BEROCONF} delete root lighttpd-ssl-failed ## not used anymore.
${BEROCONF} delete root appfs-update-failed
${BEROCONF} delete root tmp-notenough-space
${BEROCONF} delete root rootfs-notenough-space
${BEROCONF} delete root userapps-notenough-space
${BEROCONF} delete root rootfs-phpcgi-failed
${BEROCONF} delete root openssl-failed ## not used anymore.
${BEROCONF} delete root curl-tls-disabled ## not used anymore.
${BEROCONF} delete root TLSv1.2-disabled

exit 0
