<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/www/berogui/includes/fileManagement.php');
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

class ConfigurationActivate extends apiCall {
	
	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {
		//sanitize
		$this->_allowedParameters += array(
			'Option'                 => 'int-range',
		);
		$this->_sanitizeOptions = array('Option' => array('min' => 1, 'max' => 3));
		if ($this->sanitizeInputs() == false) return $this->_execResult;

		if (($fm = new fileManagement()) == null) {
			$this->_execResultString = 'error';
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		Helper::activateApi($this->_parameters['Option']);
		$fm->activate(false);
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>