<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/php/include/configExportImportTool.class.php');
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
require_once('/usr/local/php/include/confBackup.Class.php');
require_once('/usr/local/php/include/restore.Class.php');

class ConfigurationRestoreBackup extends apiCall {
	private $_restore;
	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
		$this->_restore = new restoreConfig(0);
	}

	function execute () {

		$fileName = $this->_files['BackupFile']['name'];
		$tempFile = $this->_files['BackupFile']['tmp_name'];

		// Do the new thing.
		if (strstr($fileName, '.config.xml')) {
			$imp = new configExportImportTool($tempFile);
			if (($configFiles = $imp->getConfigFiles()) === false) {
				$this->_execResultString = 'error:' . $fileName . ';';
				$this->_execResult = false;
				$this->_execResponseCode = 400;
				return($this->_execResult);
			}

			// create backup-directory
			if (!is_dir('/usr/conf/backup')) {
				@mkdir('/usr/conf/backup');
			}

			// go over configFiles
			foreach ($configFiles as $configFile) {

				// create backup of file
				@copy('/usr/conf/' . $configFile['name'], '/usr/conf/backup/' . $configFile['name']);
				@unlink('/usr/conf/' . $configFile['name']);

				// write file
				if (!($FP = fopen('/usr/conf/' . $configFile['name'], 'w'))) {
					@copy('/usr/conf/backup/' . $configFile['name'], '/usr/conf/backup/' . $configFile['name']);
					continue;
				}

				fwrite($FP, $configFile['data'], strlen($configFile['data']));
				fclose($FP);
				$FP = null;
			}

			// go over appConfigFiles
			if (($appConfigFiles = $imp->getAppConfigFiles()) !== false) {
				foreach ($appConfigFiles as $app) {
					@mkdir('/usr/conf/userapp/' . $app['name']);

					if (empty($app['files'])) {
						continue;
					}

					foreach ($app['files'] as $appFile) {
						switch ($appFile['mode']) {
						case 'directory':	system('/bin/mkdir -p /usr/conf/userapp/' . $appFile['name']);	break;
						case 'binary':		$fileData = base64_decode($appFile['content']);			break;
						default:		$fileData = $appFile['content'];				break;
						}

						if ($appFile['mode'] != 'directory') {
							@unlink('/usr/conf/userapp/' . $appFile['name']);
							$FP = fopen('/usr/conf/userapp/' . $appFile['name'], 'w');
							fwrite($FP, $fileData, strlen($fileData));
							fclose($FP);
							$FP = null;
							unset($fileData);
						}

						system('/bin/chown admin:admin /usr/conf/userapp/' . $appFile['name']);
					}
				}
			}

			$this->_restore->restoreConfig();
			Helper::activate(3);

			return($this->_execResult);
		}

		// Do the old thing.
		$cb = new confBackup();
		switch ($cb->verifyFileName($fileName)) {
		case 0:
			$this->_execResultString = 'error:invalid_filename;';
			$this->_execResult = false;
			$this->_execResponseCode = 400;
			return($this->_execResult);
		case 1:
			$res = $cb->installConfFile($fileName, $tempFile);
			break;
		case 2:
		case 3:
			$res = $cb->installFullBackup($fileName, $tempFile);
			break;
		}

		if ($res == false) {
			$this->_execResultString = 'error:' . $fileName . ';';
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		$this->_restore->restoreConfig();
		Helper::activate(3);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>