<?php

require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class CellBroadcastMessageService {

	private		$_isgw,
			$_error,
			$_errorMessage;

	function __construct ()  {

		$this->_error = false;
		$this->_errorMessage = '';

		$this->_isgw = new isgwtelnet();
		if ($this->_isgw->isgw_login() == false) {
			$this->_error = true;
			$this->_errorMessage = 'Connection refused by ISGW';
		}

		foreach (array('in', 'partial') as $folder) {
			if (!file_exists('/tmp/cbm/' . $folder)) {
				@exec('/bin/mkdir -p /tmp/cbm/' . $folder);
			}
		}
	}

	public function getErrorText () {
		return(($this->_error = true) ? $this->_errorMessage : false);
	}


	public function listMessages ($queueName) {

		if (!in_array($queueName, array('in', 'parts'))) {
			return(null);
		}

		if (($dp = @opendir('/tmp/cbm/' . $queueName)) == null) {
			return(null);
		}

		$ret = array();
		while (($file = readdir($dp)) !== false) {
			if (($file == '.') || ($file == '..')) {
				continue;
			}

			if ($queueName == 'lists') {
				$ret[] = $file;
				continue;
			}

			if (preg_match('/.*\.cbm$/', $file)) {
				$ret[] = basename($file, '.cbm');
			}
		}

		return($ret);
	}

	public function getMessage ($queueName, $cbmId) {

		if (!in_array($queueName, array('in', 'parts'))) {
			return(null);
		}

		switch ($queueName) {
		case 'in':
			$cbmFile = '/tmp/cbm/' . $queueName . '/' . $cbmId . '.cbm';
			$ret['message'] = (!file_exists($cbmFile)) ? 'Message not found' : @file_get_contents($cbmFile);
			break;
		case 'parts':
			$cbmFile = '/tmp/cbm/' . $queueName . '/' . $cbmId . '.cbm';
			$ret['message'] = (!file_exists($cbmFile)) ? 'Message not found' : @file_get_contents($cbmFile);
			$ret['log'] = (!file_exists($cbmFile . '.log')) ? '' : @file_get_contents($cbmFile . '.log');
			break;
		}

		return($ret);
	}

	public function deleteMessage ($queueName, $cbmId) {

		if (!in_array($queueName, array('in', 'parts'))) {
			return;
		}
		switch ($queueName) {
		case 'in':
			@unlink('/tmp/cbm/' . $queueName . '/' . $cbmId . '.cbm');
			break;

		case 'parts':
			@unlink('/tmp/cbm/' . $queueName . '/' . $cbmId . '.cbm');
			break;
		}
	}


}
?>
