<?php
/**
 * @file
 * Modal form für CAS Portgruppen
 */
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
require_once('/usr/local/www/berogui/includes/Helper/HelperPstn.php');

$load_popup = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
$list_get = array('gr' => 'group-name', 'opt' => 'opt');

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid);

/* [CHECKING POST REQUEST] */
unset($_POST);

/* [LOADING POPUP] */
if (!$load_popup) {
        echo "<script>window.location='../../index.php?m=Cas&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

chdir("../..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
include("./misc/config_parameter.php");
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once "./includes/isgwtelnet.php";
require_once('/usr/local/www/berogui/includes/session.php');

$group = '"general"';
$query_comp = $ba->select("SELECT * FROM cas_channels");
while ($entry = $ba->fetch_array($query_comp)) {
	if ($entry['gr'] != $_GET['gr'])
		$group .= ',' . '"' . $entry['gr'] . '"';
}
?>


<script type="text/javascript">
    var validator = $("#casform").validate({

        rules: {

            group: {
                required: true,
                checkDigChar: true,
                compareName: [<?php echo $group; ?>]
            },
            clip: {
                required: true,
		digits: true
            },
	    cnip: { 
		alphanumeric: true
	    },
            'channels[]': {
                atLeastOnePort: true,
            },
	    fxo_callerid_detection_timeout: {
		digits: true
	    },
	    interdigit_timeout: {
		digits: true
	    },
	    interdigit_timeout_initial: {
		digits: true
	    },
	    dialtone_digits: {
		digits: true
	    },
	    addit_options: {
		checkManual: true
	    }
	}
    });

    $(document).ready(function () {
        $('[data-toggle="tooltip"]').tooltip({placement: 'auto bottom', html: true, trigger: 'hover', container: 'body'});
        $('input[name=\"group\"]').focus();
    });

	$('#cas-tab a').on('hide.bs.tab', function (e) {
			var valid = true;
			var tab=e.target.getAttribute('href');
			$(tab).find("input").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			$(tab).find("select").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			if (!valid)
				e.preventDefault();
		});
</script>
<?php

/**
 * Erzeugt fir Checkboxes für jeden CAS Channel
 * @param beroAri $ba DB Instanz
 * @param string $gr Gruppen name
 * @param int $lif Line interface nummer
 * @return string HTML
 */
function ports($ba, $gr, $lif) {
	$count = 0;
	$query = $ba->select("select cas.port, cas_channels.* from cas, cas_channels where lif='$lif' and cas.port=cas_channels.port");
	while ($entry = $ba->fetch_array($query)) {
		$checked = "";
		$disabled = "";
		$port[] = $entry['cas.port'];
		if ($entry['cas_channels.gr'] == $gr) {
			$checked = "checked";
		} elseif ($entry['cas_channels.gr'] != 'NULL') {
			$checked = "checked";
			$disabled = "disabled='true'";
		}

		if ($count++ % 5 == 0 || $port[count($port) - 1] != $port[count($port) - 2]) {
			$count = 1;
			$tab .= "<div class='clear'></div>";
		}
		//Channels eines neuen Ports fangen an
		if ($port[count($port) - 1] != $port[count($port) - 2]) {
			$count = 1;
			//Script zum check all
			$tab .= '<script type="text/javascript">'
				. '$("#checkAll' . $port[count($port) - 1] . '").click(function () {'
				. '$(":checkbox.channel' . $port[count($port) - 1] . '").prop("checked", this.checked);'
				. '});</script>';
			$tab .= "<div class='clearfix'>" . PSTN_PORT_DIS . ":" . $port[count($port) - 1] . " <input type='checkbox' id='checkAll" . $port[count($port) - 1] . "' >Check all</div>";
		}
		$tab .= "<div style='float:left;'><div style='float:left; width:18px;'>" . $entry['cas_channels.channel'] . "</div><input type='checkbox' class='channel" . $port[count($port) - 1] . "' name='channels[]' $checked $disabled value='" . $entry['cas_channels.channel'] . "' ></div>";
	}
	return $tab;
}

function fxo_call_ending_signal($ba, $gr) {
	if ($gr != "") {
		$query = $ba->select("select fxo_call_ending_signal from cas_channels where gr='" . sqlite_escape_string($gr) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$ret = "<fieldset>";
			$res = explode(",", $entry['fxo_call_ending_signal']);
			if (in_array("unobtainable", $res))
				$ret .= PSTN_UNOBTAINABLE_TONE_DIS . "<input type='checkbox' value='unobtainable' name='fxo_call_ending_signal[]' checked><br>";
			else
				$ret .= PSTN_UNOBTAINABLE_TONE_DIS . "<input type='checkbox' value='unobtainable' name='fxo_call_ending_signal[]'><br>";
			if (in_array("busy", $res))
				$ret .= PSTN_BUSY_TONE_DIS . "<span style='margin-left:42px;'><input type='checkbox' value='busy' name='fxo_call_ending_signal[]' checked></span>";
			else
				$ret .= PSTN_BUSY_TONE_DIS . "<span style='margin-left:42px;'><input type='checkbox' value='busy' name='fxo_call_ending_signal[]'></span>";
			$ret .= "</fieldset>";
		}
		return $ret;
	}else {
		return "<fieldset>" . PSTN_UNOBTAINABLE_TONE_DIS . "<input type='checkbox' value='unobtainable' name='fxo_call_ending_signal[]' checked><br>" . PSTN_BUSY_TONE_DIS .
			"<span style='margin-left:42px;'><input type='checkbox' value='busy' name='fxo_call_ending_signal[]'></span></fieldset>";
	}
}

$config_values = array();
?>
<div>

	<!-- Nav tabs -->
	<ul class='nav nav-tabs' role='tablist' id='cas-tab'>
		<li role='presentation' class='active'><a href='#settings' aria-controls='settings' role='tab' data-toggle='tab'>Settings</a></li>
		<li role='presentation'><a href='#config-string' aria-controls='config-string' role='tab' data-toggle='tab'>More</a></li>
	</ul>

	<form name='casform' id='casform' action='modules/Cas/cas_submit.php?opt=<?php echo $_GET['opt']; ?>' method='POST' class='form-horizontal'>
		<div class='tab-content'>
			<div role='tabpanel' class='tab-pane active' id='settings' style='padding-top:15px;'>
				<div class='form-group group' data-toggle='tooltip' title='<?php echo CAS_GROUP_NAME; ?>'>
					<label for='group' class='col-sm-3 control-label'><?php echo PSTN_NAME_DIS; ?></label>
					<div class='col-sm-8'>
						<input name='group' id='group' class='form-control input-sm' type='text' value='<?php echo $_GET['gr']; ?>'>
					</div>
				</div>
				<!--is channels[] the right name? -->
				<div class='form-group channels[]'>
					<label for='channels[]' class='col-sm-3 control-label'><?php echo PSTN_PORTS_DIS; ?></label>
					<div class='col-sm-8'>
						<div class='left'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 0); ?></div>
							<div> <?php echo ports($ba, $_GET['gr'], 0); ?></div>
						</div>
						<div class='left' style='margin-left:50px;'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 1); ?></div>
							<div> <?php echo ports($ba, $_GET['gr'], 1); ?></div>
						</div>
						<?php if (Helper::getType() == 30) { ?>
						<div class='left' style='margin-left:50px;'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 2); ?></div>
							<div> <?php echo ports($ba, $_GET['gr'], 2); ?></div>
						</div>
						<?php } ?>
					</div>
				</div>
				<div class='form-group cas_channels'>
					<label for='cas_channels' class='col-sm-3 control-label'><?php echo PSTN_TONES_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::tones($ba, $_GET['gr'], 'cas_channels'); ?></div>
					</div>
				</div>
				<div class='form-group t1sigtype'>
					<label for='t1sigtype' class='col-sm-3 control-label'><?php echo PSTN_T1SIGTYPE_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 't1sigtype', 'cas_channels', array('fxo_ks' => 'fxo_ks', 'fxs_ks' => 'fxs_ks')); ?></div>
					</div>
				</div>
				<div class='form-group e1sigtype'>
					<label for='e1sigtype' class='col-sm-3 control-label'><?php echo PSTN_E1SIGTYPE_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'e1sigtype', 'cas_channels', array('mfcr2' => 'mfcr2')); ?></div>
					</div>
				</div>
				<div class='form-group interdigit_timeout_initial_tr'>
					<label for='interdigit_timeout_initial' class='col-sm-3 control-label'><?php echo PSTN_OVERLAPDIAL_TIMEOUT_EMPTY_DAD_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'interdigit_timeout_initial', 'cas_channels', '15'); ?></div>
					</div>
				</div>
				<div class='form-group interdigit_timeout_initial_tr'>
					<label for='interdigit_timeout' class='col-sm-3 control-label'><?php echo PSTN_ODT_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'interdigit_timeout', 'cas_channels', '3'); ?></div>
					</div>
				</div>
				<div class='form-group overlap_dialing' data-toggle='tooltip' title='<?php echo ISDN_OVERLAPDIALING; ?>'>
					<label for='interdigit_timeout' class='col-sm-3 control-label'><?php echo PSTN_OVERLAP_DIALING_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<div> <?php echo HelperPstn::checkbox($ba, $_GET['gr'], 'overlap_dialing', 'cas_channels'); ?></div>
					</div>
				</div>
				<div class='form-group clip' data-toggle='tooltip' title='<?php echo ANALOG_CLIP; ?>'>
					<label for='clip' class='col-sm-3 control-label'><?php echo PSTN_CLIP_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'clip', 'cas_channels'); ?></div>
					</div>
				</div>
				<div class='form-group cnip' data-toggle='tooltip' title='<?php echo ANALOG_CNIP; ?>'>
					<label for='cnip' class='col-sm-3 control-label'><?php echo PSTN_CNIP_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'cnip', 'cas_channels'); ?></div>
					</div>
				</div>
				<div class='form-group chansel' data-toggle='tooltip' title='<?php echo PSTN_CHANSEL; ?>'>
					<label for='chansel' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel', 'cas_channels', array('standard' => 'standard', 'random' => 'random', 'roundrobin' => 'roundrobin')); ?></div>
					</div>
				</div>
				<div class='form-group chansel_dir'>
					<label for='chansel_dir' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIR_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel_dir', 'cas_channels', array('ascending' => 'ascending', 'descending' => 'descending')); ?></div>
					</div>
				</div>
				<div class='form-group dialtone_digits'>
					<label for='dialtone_digits' class='col-sm-3 control-label'><?php echo PSTN_DIALTONE_DIGITS_DIR_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'dialtone_digits', 'cas_channels', '0'); ?></div>
					</div>
				</div>
				<div class='form-group wait_for_oad'>
					<label for='wait_for_oad' class='col-sm-3 control-label'><?php echo PSTN_WAIT_FOR_OAD_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'wait_for_oad', 'cas_channels', array('wait' => 'wait', 'dontwait' => 'dontwait')); ?></div>
					</div>
				</div>
				<div class='form-group pcmlaw'>
					<label for='pcmlaw' class='col-sm-3 control-label'><?php echo PSTN_PCMLAW_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'pcmlaw', 'cas_channels', array('default' => 'default', 'alaw' => 'alaw', 'ulaw' => 'ulaw')); ?></div>
					</div>
				</div>
				<div class='form-group fxo_wait_for_oad'>
					<label for='fxo_wait_for_oad' class='col-sm-3 control-label'><?php echo PSTN_FXO_WAIT_FOR_OAD_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'fxo_wait_for_oad', 'cas_channels', array('wait' => 'wait', 'dontwait' => 'dontwait')); ?></div>
					</div>
				</div>
				<div class='form-group fxo_callerid_detection_timeout'>
					<label for='fxo_callerid_detection_timeout' class='col-sm-3 control-label'><?php echo PSTN_FXO_CALLERID_DETECTION_TIMEOUT_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'fxo_callerid_detection_timeout', 'cas_channels', '5'); ?></div>
					</div>
				</div>
				<div class='form-group fxo_call_ending_signal'>
					<label for='fxo_call_ending_signal' class='col-sm-3 control-label'><?php echo PSTN_FXO_CALL_ENDING_SIGNAL_DIS; ?></label>
					<div class='col-sm-8  form-checkbox'>
						<div> <?php echo fxo_call_ending_signal($ba, $_GET['gr']); ?></div>
					</div>
				</div>
				<div class='form-group fxo_cid_detection_mode'>
					<label for='fxo_cid_detection_mode' class='col-sm-3 control-label'><?php echo PSTN_FXO_CID_DETECTION_MODE_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'fxo_cid_detection_mode', 'cas_channels', array('Bellcore' => 'Bellcore', 'ETSI-DTMF' => 'ETSI-DTMF', 'ETSI-DTMF-AR' => 'ETSI-DTMF-AFTER-RINGING')); ?></div>
					</div>
				</div>
			</div>
			<div role='tabpanel' class='tab-pane' id='config-string' style='padding-top:20px;'>
				<div class="row failover_proxy failover_timeout">
					<p class="lead text-center"><?php echo DIALPLAN_CONFIGURATION_DIS; ?></p>
				</div>
				<div class='form-group addit_options'  data-toggle='tooltip' title='<?php echo ADDIT_OPTIONS; ?>'>
					<label for='addit_options' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DIS; ?></label>
					<div class='col-sm-8'>
						<textarea name='addit_options' id='addit_options' class='form-control' rows='5'></textarea>
					</div>
				</div>
				<div class='form-group addit_options'>
					<label for='extra_tooltip' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DOC_DIS; ?></label>
					<div class='col-sm-8'>
						<p id='extra_tooltip' class='form-control-static' style='height: 170px; overflow: auto; border: 1px solid #A31D26; resize:both;'></p>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
			<div class='text-center'><i><?php echo REQUIRED_FIELDS; ?></i></div>
		</div>
		<?php
		if (isset($_GET['gr'])) {
			HelperPstn::showdefmc($config_values, 'c', 'cas_channels');
		} else {
			HelperPstn::show_confadd($config_values, 'c');
		}
		?>
		<br/>
		<input type='hidden' name='gr_upd' value='<?php echo $_GET['gr']; ?>'>
		<div class='text-center'>
			<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_SAVE; ?>' >
		</div>
	</form>
</div>

