<?php
/**
 * Implementiert CRUD Operationen für BRI und PRI Portgruppen
 * 
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Isdn {

	private 	$m_attr;
	private 	$opt_attr;

	private		$isRequestRejected = 0,
				$reasonRejected = array();

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array()) {
		// set main variable from GET
		$this->m_attr = $m;

		// check GET variable
		$load_opt = 1;
		$this->opt_attr = strtoupper(Helper::sanitizeGet($get['opt'], 'opt', $load_opt));
		if (!$load_opt || strlen($get['opt']) == 0) {
			// set default depending module plugged
			$beroAri = new beroAri();

			if (sqlite_num_rows($beroAri->select("SELECT * from isdn where port_type='PRI'")) > 0) {
				$this->opt_attr = 'PRI';
			}
			else {
				$this->opt_attr = 'BRI';
			}
		}

		// get error from modal or submit execution
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Inhalt
	 */
	function display() {

		$m = $this->m_attr;
		$opt = $this->opt_attr;

		// set page title
                $name = "ISDN_".$opt."_TITLE_DIS";
		include('./includes/header.php');

                if ($this->isRequestRejected) {
                        $ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
                }

		$isdn_table = $this->dynamic_table();

		// build page content
		$ret .= "
			<script>
			function del(table,option,opt){
				conf = confirm('".PSTN_DELETE_MESS1_DIS." '+option+'? ".PSTN_DELETE_MESS2_DIS."');
				if (conf==false)
					return false;
				else
					window.location='./misc/delete.php?m=".$m."&gr='+option+'&table='+table+'&opt='+opt;
			}
			</script>
			<div class='modal fade bs-example-modal-lg' id='isdn-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
				  <div class='modal-dialog modal-lg'>
				    <div class='modal-content'>
				      <div class='modal-header'>
					<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
					<h4 class='modal-title' id='myModalLabel'>ISDN-" .  $opt . "</h4>
				      </div>
				      <div class='modal-body'>
				      </div>
				    </div>
				  </div>
				</div>
			<br>
			<div class='container table-responsive'>
				" . $isdn_table . "
			</div>
			<br>
			<div class='text-center'>
			<a href='modules/Isdn/isdn_popup.php?opt=" . $opt . "' role='button' data-remote='false' data-toggle='modal' data-target='#isdn-popup' class='btn btn-default'>
				" . BUTTON_ADD . "
			</a>
		</div>
			<script>
			$('#isdn-popup').on('show.bs.modal', function(e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
			$('#isdn-popup').on('hidden.bs.modal', function (e) {
				$('.modal-body').empty();
			});
		</script>";


		//Rückgabe: Inhalt der HTML-Seite
		return $ret;
	}

	/**
	 * Erstellt die HTML Tabelle für die ISDN Portgruppen
	 * @return string HTML Tabelle
	 */
	function dynamic_table() {
		//ein neues Datenbankobjekt wird erzeugt.
		$ba = new beroAri();
		require_once("./includes/lang.php");

		$cols .= "<th>".PSTN_GROUP_DIS."</th>";
		$cols .= "<th>".PSTN_PORTS_DIS."</th>";
		/*Die Einträge werden von der Tabelle isdn gelesen, formatiert und in einer
		  Tabelle geschrieben, zusätzlich werden 2 Knöpfe eingebaut: modify und delete*/
		$opt = $this->opt_attr;
		$query = $ba->select('SELECT DISTINCT gr FROM isdn WHERE gr!="NULL" and port_type="'.sqlite_escape_string($opt).'"');
		$rows = '';
		while ($entry = $ba->fetch_array($query)) {
			$query_port = $ba->select('SELECT port FROM isdn WHERE gr=\''.$entry['gr'].'\' ORDER BY port asc');
			$ports="";
			while ($entryp = $ba->fetch_array($query_port)) {
				if($ports!=""){
					$ports.=",".$entryp['port'];
				}else{
					$ports.=$entryp['port'];
				}
			}
			$rows.="<tr><td>".$entry['gr']."</td><td>".$ports."</td>";
			$rows .= "<td class='buttons'>
						<a href='modules/Isdn/isdn_popup.php?gr=" . $entry['gr'] . "&opt=" . $opt . "' data-remote='false' data-toggle='modal' data-target='#isdn-popup' class='popup_download'>
					<img src='./includes/images/modify.png' onmouseover=\"Tip('" . MOD_ISDN_MODIFY . "')\" onmouseout='UnTip()'>
				</a>&nbsp;
				<a class='popup_download' onclick=\"del('isdn','".$entry['gr']."','".$opt."');\">
            	    <img src='./includes/images/delete.png' onmouseover=\"Tip('" .
					MOD_ISDN_DELETE . "')\" onmouseout='UnTip()'>
				</a>

			</td></tr>";
		}


		$table = "<table class='table table-striped table-bordered' id='table' style='max-width:700px; margin:auto;'><tr>" . $cols . "<th></th></tr>" . $rows . "</table>";
		//Rückgabe: Erzeugte Tabelle mit den Einträgen der Tabelle isdn der Datenbank
		return $table;
	}

}
?>
