<?php
/**
* implementiert die CRUD Operationen für SIP Konten
* @author Miguel Palmer <mp@beronet.com>
*/

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Sip {

private		$m_attr,
		$q_attr,
		$start_attr,
		$order_attr,
		$sort_attr;

private		$isRequestRejected = 0,
		$reasonRejected = array();

/**
 * Constructor
 */
function __construct($m, $get = array(), $post = array(), $session = array()) {
	// set main index page
	$this->m_attr = $m;

	// check GET variable
            $this->q_attr 	  = isset($get['q']) 	 ? Helper::sanitizeGet($get['q']	 , 'q'	  ) : 0;
            $this->start_attr = isset($get['start']) ? Helper::sanitizeGet($get['start']	 , 'start') : 0;
            $this->order_attr = isset($get['order']) ? Helper::sanitizeGet($get['order']	 , 'order') : 0;
            $this->sort_attr  = isset($get['sort'])  ? Helper::sanitizeGet($get['sort'] 	 , 'sort' ) : 0;

	// get error from modal or submit execution
	if (isset($get['error'])) {
		$this->isRequestRejected = 1;
		$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
		unset($get['error'], $get['request'], $get['checkor'], $get['key']);
	}
}

/**
 * Generiert den Inhalt von der HTML-Seite
 * @return string HTML Seite
 */
function display() {

	include "./includes/functions.php";

	// args
	$m = $this->m_attr;
	$q = $this->q_attr;
	$start = $this->start_attr;
	$order = $this->order_attr;
	$sort = $this->sort_attr;

	$ba = new beroAri();

	$span = 15;
	$query = $ba->select('SELECT * FROM sip');
	$record_count = sqlite_num_rows($query);
	$test=$record_count/$span;
	$test=(int)$test;
	if ($record_count==0){
		$next_add=0;
	}else{
		$next_add=($test*$span);
	}

	$start = $start == '' ? 0 : $start;
            
    	$name = "SIP_TITLE_DIS";
	include('./includes/header.php');

	if ($this->isRequestRejected) {
		$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
	}

	$sip_table = $this->dynamic_table();

	// build page content
	$ret .= "<script>
			function del(table,option,name){
				conf = confirm('".SIP_DELETE_MESS1_DIS." '+name+'? ".SIP_DELETE_MESS2_DIS."');
				if (conf==false)
					return false;
				else
					window.location='./misc/delete.php?m=".$this->m_attr."&id='+option+'&table='+table+'&name='+name;
			}
		</script>
		<div class='modal fade bs-example-modal-lg' id='sip-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
		  <div class='modal-dialog modal-lg'>
		    <div class='modal-content'>
		      <div class='modal-header'>
			<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
			<h4 class='modal-title' id='myModalLabel'>" . SIP_TITLE_DIS . "</h4>
		      </div>
		      <div id='sip-modal-body' class='modal-body'>
		      </div>
		    </div>
		  </div>
		</div>
		 <br>
		 <div id='container table-responsive'>
		 " . $sip_table . "
		 </div>
		 <div class='text-center'>
			<a href='modules/Sip/sip_popup.php?start=$next_add&profile=undefined&type=manual' role='button' data-remote='false' data-toggle='modal' data-target='#sip-popup' class='btn btn-default'>
			" . BUTTON_ADD . "
			</a>
		 </div>";


//				<a href='modules/Sip/sip_popup.php?start=" . $next_add . "' role='button' data-remote='false' data-toggle='modal' data-target='#sip-popup' class='btn btn-default'>   /* Old code: used to add different predefined profiles

	//Erzeugung der Navigationsleiste.
	$functions = new functions();
	$query = $ba->select('SELECT * FROM sip');
	$record_count = sqlite_num_rows($query);
	$url_opts = array ();
	$url_opts['sort'] = $sort;
	$url_opts['order'] = $order;
	$ret .= "<div class='text-center'>".
		$functions->displayNavigationBlock($m, $q, $url_opts, $start, $span, $record_count).
		"</div>";

	return $ret;
}

/**
 * Generiert die HTML Tabelle mit den SIP Einträgen
 * @return string HTML Tabelle
 */
function dynamic_table() {
	$ba = new beroAri();
	$bc = new beroConf('root');

	require_once("./includes/lang.php");
	$start = $this->start_attr;
	$advgui = ($ba->get('gui_mode') == 'advanced') ? true : false;

	//Das Header der Tabelle sind die Spaltennamen von dialplan
	$columns = $ba->column_type('sip');
	$i = 0;
            //$columnsToShow=array("name","user","register","profile"); /* Old code: used to display different predefined SIP-profile */
            //$colName=array("name"=>SIP_NAME_DIS,"user"=>SIP_USER_DIS,"register"=>SIP_REGISTER_DIS,"profile"=>SIP_PROFILE_DIS); /* Old code: used to display different predefined SIP-profile */
            $columnsToShow=array(
            	"name",
            	"user",
            	"register",
            );
            $colName=array(
            	"name"=>SIP_NAME_DIS,
            	"user"=>SIP_USER_DIS,
            	"register"=>SIP_REGISTER_DIS,
            );

            if ($advgui) {
            	$columnsToShow = array_merge($columnsToShow, array("sip_stack","callgroup_name"));
            	$colName = array_merge($colName, array("sip_stack"=>SIP_STACK_DIS,"callgroup_name"=>CALLGROUP_NAME));
            }
	foreach ($columns as $column => $type) {
		if (in_array($column,$columnsToShow)) $cols .= "<th>" . $colName[$column] . "</th>";
	}

	if ($bc->get('root', 'is-sbc-vm') == 1) {
		$stacks['wan'] = 'WAN'. ($ba->get('stack_active_wan') == 0 ? ' (deactivated)' : '');
		if ($bc->get('root', 'is-vpn-running') == 1) {
			$stacks['lan'] = 'LAN/VPN';
		}
		$stacks['localhost'] = 'localhost';
	}
	else {
		$stacks = array('lan' => 'LAN', 'localhost' => 'localhost');
		if ((int) $ba->get('stack_active_lan') === 0){
			$stacks['lan'] = 'LAN (deactivated)';
		}
		if ($bc->get('root', 'lan-mode') == 'lan-wan' && ((int) $ba->get('stack_active_wan') === 1)) {
			$stacks['wan'] = 'WAN';
		}
		if (is_dir('/home/admin/apps/openvpn/') && ((int) $ba->get('stack_active_vpn') === 1)) {
			$stacks['vpn'] = 'VPN';
		}
	}

	foreach ($stacks as $name => $value) {
			$stacks_opt .= "<option value='" . $name . "'>" . $value . "</option>";
	}

	/*Die Einträge werden von der Tabelle sip gelesen, formatiert und in einer
	  Tabelle geschrieben, zusätzlich werden 2 Knöpfe eingebaut: modify und delete*/
	$page = (($start / 15) + 1);
	if (!$start)
		$start = 0;
	$id = 0;
	for ($j = 1; $j <= $page; $j++) {
		$query = $ba->select('SELECT * FROM sip ORDER BY id asc limit 15 offset ' . sqlite_escape_string($start));
		$rows = '<tbody>';
		while ($entry = $ba->fetch_array($query)) {
			$rows .= "<tr>";
			$rows .= "<td class='checkall'><form>
            	<input type='checkbox' name='entryid' class='entryid' value1='" . $entry['id'] . "' value2='". $entry['name']."'>
            </form></td>";
			for ($i = 0; $i < (count($columnsToShow)); $i++) {
				$col_name = $columnsToShow[$i];
				$rows .= "<td>" . $entry[$col_name]  . "</td>";

			}
			$id = $entry['id'];
			$rows .= "<td class='buttons'>
				
			 <a href='modules/Sip/sip_popup.php?id=" . $entry['id'] . "' data-remote='false' data-toggle='modal' data-target='#sip-popup' class='popup_download'>
				<img src='./includes/images/modify.png' onmouseover=\"Tip('" . MOD_SIP_MODIFY . "')\" onmouseout='UnTip()'>
			</a>&nbsp;
			<a href='modules/Sip/sip_popup.php?id=" . $entry['id'] ."&copy=1' data-remote=false data-toggle='modal' data-target='#sip-popup' class='popup_download'>
				<img src='./includes/images/copy.png' onmouseover=\"Tip('" . MOD_SIP_COPY . "')\" onmouseout='UnTip()'>
			</a>&nbsp;
			<a class='popup_download' onclick=\"del('sip','".$id."','".$entry['name']."');\">
        	    <img src='./includes/images/delete.png' onmouseover=\"Tip('" . MOD_SIP_DELETE . "')\" onmouseout='UnTip()'>
			</a>
			</td></tr>";
		}
		$rows .= '</tbody>';
	}

	$table = "<table class='table table-striped table-bordered'><tr><thead>
		<th class='checkall'><div  data-toggle='tooltip' title='" . DIALPLAN_CHECK_ALL_DIS . "'>
			<input type='checkbox' id='checkall' >
		</div></th>
		" . $cols . "
		<th>" . DIALPLAN_TOOLS_DIS . "</th></tr></thead>
		" . $rows . "
	</table>
	<img src='./includes/images/arrow.jpg' class='multi-action-arrow'>
	<select class='form-control multi-action-select' name='action' id='action' onchange='toggleAction()'>
		<option value='none' selected disabled>" . SIP_ACTION_DIS . "</option>
		<option value='delete'>". 		SIP_ACTION_DEL_DIS 		." </option>
		<!-- <option value='enable'>". 		SIP_ACTION_ENABLE_DIS 		." </option>
		<option value='disable'>". 		SIP_ACTION_DISABLE_DIS 		." </option> -->
		<option value='register'>". 	SIP_ACTION_REG_DIS		." </option>
		<option value='validate'>". 	SIP_ACTION_VALID_DIS		." </option>";
	if ($advgui) $table .=
		"<option value='stack'>". 		SIP_ACTION_STACK_DIS 		." </option>
		<option value='callgroup'>". 	SIP_ACTION_GROUP_DIS 	." </option>";
	$table .= "
	</select>

	&nbsp;

	<div class='multiaction' id='none' style='display:inline;'><input type='hidden' id='none_value' value=0></div>
	<div class='multiaction formControl' id='delete' style='display:none;'><input type='hidden' id='delete_value' value=1></div>
	<div class='multiaction formControl' id='enable' style='display:none;'><input type='hidden' id='enable_value' value=1></div>
	<div class='multiaction formControl' id='disable' style='display:none;'><input type='hidden' id='enable_value' value=0></div>

	<div class='multiaction formControl' id='register' style='display:none;'>
		<input type='checkbox' div='multiaction' name='register' id='register_value' checked>
		<label for='register_value'>&nbsp;" . SIP_REGISTER_DIS . "</label>
	</div>

	<div class='multiaction formControl' id='validate' style='display:none;'>
		<input type='checkbox' div='multiaction' name='validate' id='validate_value' checked>
		<label for='validate_value'>&nbsp;" . SIP_VALIDATION_DIS . "</label>
	</div>

	<div class='multiaction formControl' id='stack' style='display:none;'>
		<select class='form-control multi-action-input' name='stack' id='stack_value'>
			" . $stacks_opt . "
		</select>
	</div>

	<div class='multiaction formControl' id='callgroup' style='display:none;' data-toggle='tooltip' data-placement='top' title='" . CALLGROUP_TOOLTIP . "'>
		<label for='callgroup_value'>&nbsp;" . CALLGROUP_NAME . " </label>
		<input class='form-control multi-action-input' name='callgroup' id='callgroup_value' value=''>
	</div>

	&nbsp;

	<a href='javascript:void sendForm();' class='btn btn-default' style='vertical-align:unset;' >" . FACTORY_RESET_APPLY . " </a>

	<script>

		$('input[div=\"multiaction\"]').on('change', function(){
   			this.value = this.checked ? 1 : 0;
		}).change();

		$('#sip-popup').on('show.bs.modal', function(e) {
			var link = $(e.relatedTarget);
			$('#sip-modal-body').load(link.attr('href'));
		});

		$('#sip-popup').on('hidden.bs.modal', function (e) { 
			$('#sip-modal-body').empty(); 
		}); 

		$('#checkall').click(function(event) {
			if (this.checked){
				$('.entryid').each(function() { 
					this.checked = true;               
				});
			} else {
				$('.entryid').each(function() { 
					this.checked = false;               
				});
			}
		});

		function toggleAction() {

			var action = document.getElementById('action').selectedOptions[0].value;
			var divsToHide = document.getElementsByClassName('multiaction'); //divsToHide is an array
			for(var i = 0; i < divsToHide.length; i++) {
				divsToHide[i].style.display = 'none'; // depending on what you're doing
			}
			document.getElementById(action).style.display='inline';
		}

		function sendForm () {

			var action = document.getElementById('action').selectedOptions[0].value;
			var action_value = document.getElementById(action+'_value').value;
			var entryid=[];
			var entryname=[];
			var i=0;

			$('.entryid').each(function () {
				if ($(this).prop('checked')==true) {
					entryid[i]=$(this).attr('value1');
					entryname[i]=$(this).attr('value2');
					i++;
				}
			});

			if (i>0) {	
				if (action=='delete') {
					Check = confirm('" . DIALPLAN_DELETE_BULKMESSAGE_DIS . "');
					if (Check == false) return false;  
				}

				$.post('./modules/Sip/sip_action.php', { 
					entryid : entryid,
					entryname : entryname,
					action: action,
					action_value: action_value,
				}).done (function (data) {
					location.reload();
				});
			} 
		}
	</script>";
	//Rückgabe: Erzeugte Tabelle mit den Einträgen der Tabelle sip der Datenbank
	return $table;
}

}
?>
