<?PHP
$m = 'SipStack';
$berogui_path = "/usr/local/www/berogui";

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include($berogui_path .'/includes/session.php');
unset($newTarget);

/* [INCLUDE] */
include('/usr/fallback/beroConf.php');
include_once($berogui_path ."/misc/database.php");
include_once($berogui_path ."/includes/Helper/Helper.php");

/* [FUNCTIONS] */
/**
 * Saves the SIP general settings to the database
 * @param beroAri $ba
 * @return string
 */

/** // TODO !!
 * The submit can be clearly optimized if the $_POST variables is given as:
 *
 *      $_POST = [
 *        'lan' => [blabla],
 *        'wan' => [blabla],
 *        'vpn' => [blabla],
 *      ];
 */

function save($ba, $post, $iface) {
	if (!in_array('tls', $post["sip_transport_$iface"])) {
		$post["ssl_version_$iface"] = '';
		$post["tls_verification_selection_$iface"] = '';
	}
	$post["sip_transport_$iface"] = implode(':', $post["sip_transport_$iface"]);
	foreach (array_keys($post) as $key) {
		if (preg_match("/.*_$iface/", $key)) {
			$ba->set($key, sqlite_escape_string($post[$key]));
		}
	}
}

function upload($ba, $iface, $files) {
	$response = array();
	$file_name = $files["uploadfile_cafile_$iface"]["name"];
	$tmp_file = $files["uploadfile_cafile_$iface"]["tmp_name"];
	if ($files["uploadfile_cafile_$iface"]["name"] != "") {
		if ($files["uploadfile_cafile_$iface"]["size"] > 51200) { //50 kB
			$response[$iface .'_ca_punkt'] = 'rot';
		}
		else {
			exec("mkdir -p /usr/conf/certs/$iface");
			exec("/bin/cp " . $tmp_file . " /usr/conf/cafile_$iface.pem");
			exec("/bin/cp " . $tmp_file . " /usr/conf/certs/$iface/cafile.pem");
			
			$response[$iface .'_ca_punkt'] = 'gruen';
		}
	}
	$file_name = $files["uploadfile_agent_$iface"]["name"];
	$tmp_file = $files["uploadfile_agent_$iface"]["tmp_name"];
	if ($files["uploadfile_agent_$iface"]["name"] != "") {
		
		if ($files["uploadfile_agent_$iface"]["size"] > 51200) { //50 kB
			$response[$iface .'_ag_punkt'] = 'rot';
		}
		else {
			exec("mkdir -p /usr/conf/certs/$iface");
			exec("/bin/cp " . $tmp_file . " /usr/conf/agent_$iface.pem");
			exec("/bin/cp " . $tmp_file . " /usr/conf/certs/$iface/agent.pem");

			$response[$iface .'_ag_punkt'] = 'gruen';
		}
	}
	return $response;
}

/* [GENERAL VARIABLES] */
$exec_ajax = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING POST REQUEST] */
unset($_POST['m'], $_POST['a'], $_POST['submit']);

$list_post = array();
$list_options = array();
foreach(array('lan', 'wan', 'vpn') as $iface) {
	// for the ToS: only int >= 0 ... we should maybe limit to the higher byte (mix and max value)
	$list_iface_post = array(
		"sip_transport_$iface" => 'select', "ssl_version_$iface" 	=> 'select'   , "tos_rtp_$iface"  => 'int>=0'	 ,
		"tos_sip_$iface"       => 'int>=0', "rtp_port_selection_$iface" => 'select'   , "rtpports_$iface" => 'int-ranged',
		"stack_active_$iface"  => 'bool'  , "sip_bindport_$iface" 	=> 'int-range', "tls_verification_selection_$iface" 	=> 'select',
		"sip_useragent_$iface" => 'str-length',
		"registration_offset_$iface"  => 'int-range',
	);
				
	$list_post = array_merge($list_post, $list_iface_post);

	$list_options = array_merge($list_options, array(
		"sip_bindport_$iface"		=> array('min' => 1, 'max' => 65535)	,
		"sip_transport_$iface"		=> array('tls', 'udp', 'tcp')		,
		"ssl_version_$iface"		=> array("tls1.0", "tls1.1", "tls1.2")		,
		"tls_verification_selection_$iface"		=> array("all", "incoming", "outgoing", "none")		,
		"rtp_port_selection_$iface"	=> array("standard", "roundrobin")	,
		"sip_useragent_$iface" => array('min' => 1, 'max' => 150),
		"registration_offset_$iface" => array('min' => 0, 'max' => 1000),
	));
}
$_POST = Helper::sanitizePost($_POST, $list_post, $exec_ajax, $invalid, $list_options);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
        echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

$ba = new beroAri(); 
$bc = new beroConf('root');

$response = array();

if ($bc->get('root', 'is-sbc-vm') == 1) {
	if ($bc->get('root', 'lan-mode') == 'lan-wan' && $bc->get('root', 'is-vpn-running') == 1) {
		$response = array_merge($response, upload($ba, 'lan', $_FILES));
		save($ba, $_POST, 'lan');
	}
	$response = array_merge($response, upload($ba, 'wan', $_FILES));
	save($ba, $_POST, 'wan');
}
else {
	if ($bc->get('root', 'lan-mode') == 'lan-wan') {
		$response = array_merge($response, upload($ba, 'wan', $_FILES));
		save($ba, $_POST, 'wan');
	}
	if (is_dir('/home/admin/apps/openvpn/')) {
		$response = array_merge($response, upload($ba, 'vpn', $_FILES));
		save($ba, $_POST, 'vpn');
	}
	$response = array_merge($response, upload($ba, 'lan', $_FILES));
	save($ba, $_POST, 'lan');
}

$rsp_str = '';
if (count($response) > 0) {
	$rsp_str = '&upld_file=1';
	foreach ($response as $param => $value) {
		$rsp_str .= "&$param=$value";
	}
}

Helper::activate(2, true, $m, ACTIVATE);
echo "<script>window.location='../../index.php?m=$m$rsp_str'</script>";
exit(1);
?>
